/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.general.FireplaceBlock;
import org.dawnoftime.dawnoftime.block.templates.ChimneyBlockDoT;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalBlock;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalSidedBlock;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalSidedPlanBlock;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class ConnectedVerticalSidedPlanFireplaceBlock
extends ConnectedVerticalSidedPlanBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public ConnectedVerticalSidedPlanFireplaceBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.MULTIBLOCK_FIREPLACE_SHAPES);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = state.getValue(ConnectedVerticalBlock.VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.NONE ? 0 : 1;
        return index + ((Direction)state.getValue((Property)ConnectedVerticalSidedBlock.FACING)).get2DDataValue() * 2;
    }

    @Override
    public InteractionResult use(BlockState stateIn, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.getMainHandItem() != null && player.getMainHandItem().getItem() instanceof BlockItem && ((BlockItem)player.getMainHandItem().getItem()).getBlock() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
            return InteractionResult.PASS;
        }
        if (stateIn.getValue(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.BOTH && stateIn.getValue(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.UNDER) {
            int activation = Utils.changeBlockLitStateWithItemOrCreativePlayer(stateIn, worldIn, pos, player, handIn);
            if (activation >= 0) {
                Direction direction = (Direction)stateIn.getValue((Property)ConnectedVerticalSidedBlock.FACING);
                worldIn.getBlockState(pos.relative(direction.getCounterClockWise())).neighborChanged(worldIn, pos.relative(direction.getCounterClockWise()), (Block)this, pos, false);
                worldIn.getBlockState(pos.relative(direction.getClockWise())).neighborChanged(worldIn, pos.relative(direction.getClockWise()), stateIn.getBlock(), pos, false);
                ConnectedVerticalSidedPlanFireplaceBlock.updateChimneys(activation == 1, stateIn, pos, worldIn);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void onProjectileHit(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        int activation = -1;
        if (!((Boolean)state.getValue((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() && !((Boolean)state.getValue((Property)FireplaceBlock.LIT)).booleanValue()) {
            if (projectile instanceof AbstractArrow) {
                activation = 1;
            }
        } else if (((Boolean)state.getValue((Property)FireplaceBlock.LIT)).booleanValue() && (projectile instanceof Snowball || projectile instanceof ThrowableProjectile && PotionUtils.getPotion((ItemStack)((ThrowableItemProjectile)projectile).getItem()).getEffects().size() <= 0)) {
            activation = 0;
        }
        if (activation >= 0) {
            boolean isActivated;
            BlockPos pos = hit.getBlockPos();
            boolean bl = isActivated = activation == 1;
            if (!worldIn.isClientSide()) {
                state = (BlockState)state.setValue((Property)FireplaceBlock.LIT, (Comparable)Boolean.valueOf(isActivated));
                worldIn.setBlock(pos, state, 10);
                worldIn.playSound(null, pos, isActivated ? SoundEvents.FIRE_AMBIENT : SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!isActivated && worldIn.isClientSide()) {
                for (int i = 0; i < worldIn.random.nextInt(1) + 1; ++i) {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (double)(worldIn.random.nextFloat() / 4.0f), 2.5E-5, (double)(worldIn.random.nextFloat() / 4.0f));
                }
            }
            ConnectedVerticalSidedPlanFireplaceBlock.updateChimneys(isActivated, state, pos, worldIn);
            Direction direction = (Direction)state.getValue((Property)ConnectedVerticalSidedBlock.FACING);
            worldIn.getBlockState(pos.relative(direction.getClockWise())).neighborChanged(worldIn, pos.relative(direction.getClockWise()), (Block)this, pos, false);
            worldIn.getBlockState(pos.relative(direction.getCounterClockWise())).neighborChanged(worldIn, pos.relative(direction.getCounterClockWise()), (Block)this, pos, false);
        }
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState newState;
        if (state.getValue(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.BOTH && state.getValue(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.UNDER && (newState = worldIn.getBlockState(fromPos)).getBlock() == this) {
            Direction facing = (Direction)state.getValue((Property)ConnectedVerticalSidedBlock.FACING);
            if (newState.getValue((Property)ConnectedVerticalSidedBlock.FACING) == facing) {
                if ((facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH)) && fromPos.getZ() != pos.getZ()) {
                    return;
                }
                if ((facing.equals((Object)Direction.EAST) || facing.equals((Object)Direction.WEST)) && fromPos.getX() != pos.getX()) {
                    return;
                }
                boolean burning = (Boolean)newState.getValue((Property)LIT);
                if (burning != (Boolean)state.getValue((Property)LIT)) {
                    if (((Boolean)newState.getValue((Property)LIT)).booleanValue() && ((Boolean)state.getValue((Property)WaterloggedBlock.WATERLOGGED)).booleanValue()) {
                        return;
                    }
                    worldIn.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(burning)), 10);
                    BlockPos newPos = pos.relative(facing.getClockWise()).equals((Object)fromPos) ? pos.relative(facing.getCounterClockWise()) : pos.relative(facing.getClockWise());
                    worldIn.getBlockState(newPos).neighborChanged(worldIn, newPos, (Block)this, pos, false);
                }
            }
        }
    }

    public static void updateChimneys(boolean isActivatedIn, BlockState blockStateIn, BlockPos posIn, Level worldIn) {
        BlockPos pos = posIn;
        BlockState blockState = null;
        while ((blockState = worldIn.getBlockState(pos)) != null && blockState.getBlock() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
            pos = pos.above();
        }
        pos = pos.below();
        ConnectedVerticalSidedPlanFireplaceBlock.updateChimneyConductsAtSide(isActivatedIn, pos.above(), worldIn);
        ConnectedVerticalSidedPlanFireplaceBlock.updateRightChimneys(isActivatedIn, blockStateIn, pos, worldIn);
        ConnectedVerticalSidedPlanFireplaceBlock.updateLeftChimneys(isActivatedIn, blockStateIn, pos, worldIn);
    }

    public static void updateLeftChimneys(boolean isActivatedIn, BlockState blockStateIn, BlockPos posIn, Level worldIn) {
        ConnectedVerticalSidedPlanFireplaceBlock.updateChimneyConductsAtSide(isActivatedIn, posIn.above(), worldIn);
        Direction facing = (Direction)blockStateIn.getValue((Property)ConnectedVerticalSidedBlock.FACING);
        BlockStatePropertiesAA.HorizontalConnection horizontalConnection = (BlockStatePropertiesAA.HorizontalConnection)((Object)blockStateIn.getValue(ConnectedVerticalSidedPlanBlock.HORIZONTAL_CONNECTION));
        if (BlockStatePropertiesAA.HorizontalConnection.RIGHT.equals((Object)horizontalConnection) || BlockStatePropertiesAA.HorizontalConnection.BOTH.equals((Object)horizontalConnection)) {
            BlockPos rightBlockPos = null;
            if (Direction.NORTH.equals((Object)facing) || Direction.SOUTH.equals((Object)facing)) {
                rightBlockPos = posIn.offset(-1, 0, 0);
            } else if (Direction.EAST.equals((Object)facing) || Direction.WEST.equals((Object)facing)) {
                rightBlockPos = posIn.offset(0, 0, -1);
            }
            BlockState leftBlockState = worldIn.getBlockState(rightBlockPos);
            if (leftBlockState.getBlock() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
                ConnectedVerticalSidedPlanFireplaceBlock.updateLeftChimneys(isActivatedIn, blockStateIn, rightBlockPos, worldIn);
            }
        }
    }

    public static void updateRightChimneys(boolean isActivatedIn, BlockState blockStateIn, BlockPos posIn, Level worldIn) {
        ConnectedVerticalSidedPlanFireplaceBlock.updateChimneyConductsAtSide(isActivatedIn, posIn.above(), worldIn);
        Direction facing = (Direction)blockStateIn.getValue((Property)ConnectedVerticalSidedBlock.FACING);
        BlockStatePropertiesAA.HorizontalConnection horizontalConnection = (BlockStatePropertiesAA.HorizontalConnection)((Object)blockStateIn.getValue(ConnectedVerticalSidedPlanBlock.HORIZONTAL_CONNECTION));
        if (BlockStatePropertiesAA.HorizontalConnection.LEFT.equals((Object)horizontalConnection) || BlockStatePropertiesAA.HorizontalConnection.BOTH.equals((Object)horizontalConnection)) {
            BlockPos rightBlockPos = null;
            if (Direction.NORTH.equals((Object)facing) || Direction.SOUTH.equals((Object)facing)) {
                rightBlockPos = posIn.offset(1, 0, 0);
            } else if (Direction.EAST.equals((Object)facing) || Direction.WEST.equals((Object)facing)) {
                rightBlockPos = posIn.offset(0, 0, 1);
            }
            BlockState rightBlockState = worldIn.getBlockState(rightBlockPos);
            if (rightBlockState.getBlock() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
                ConnectedVerticalSidedPlanFireplaceBlock.updateRightChimneys(isActivatedIn, blockStateIn, rightBlockPos, worldIn);
            }
        }
    }

    public static void updateChimneyConductsAtSide(boolean isActivatedIn, BlockPos blockPosIn, Level worldIn) {
        BlockState blockState = worldIn.getBlockState(blockPosIn);
        if (blockState.getBlock() instanceof ChimneyBlockDoT) {
            ChimneyBlockDoT.updateAllChimneyConductParts(isActivatedIn, blockState, blockPosIn, worldIn);
        }
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluid) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() || fluid.getType() != Fluids.WATER) {
            return false;
        }
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            world.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 10);
        world.scheduleTick(pos, fluid.getType(), fluid.getType().getTickDelay((LevelReader)world));
        return true;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (stateIn.getValue(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.BOTH && stateIn.getValue(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.UNDER && ((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            if (rand.nextInt(24) == 0) {
                worldIn.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            for (int i = 0; i < 3; ++i) {
                worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + rand.nextDouble() * 0.5 + 0.25, (double)pos.getY() + rand.nextDouble() * 0.5 + (double)0.6f, (double)pos.getZ() + rand.nextDouble() * 0.5 + 0.25, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "fireplace");
    }
}

