/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.IBlockSpecialDisplay;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.blockentity.DisplayerBlockEntity;
import org.dawnoftime.dawnoftime.registry.DoTBBlockEntitiesRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DisplayerBlock
extends WaterloggedBlock
implements EntityBlock,
IBlockSpecialDisplay {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    protected DisplayerBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return DoTBBlockEntitiesRegistry.INSTANCE.DISPLAYER.get().create(pPos, pState);
    }

    @NotNull
    public InteractionResult use(@NotNull BlockState blockState, Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (hit.getDirection() != Direction.UP) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        Vec3 hitVec = hit.getLocation();
        double localX = hitVec.x - (double)pos.getX();
        double localZ = hitVec.z - (double)pos.getZ();
        int gridX = (int)(localX * 3.0);
        int gridZ = (int)(localZ * 3.0);
        gridX = Mth.clamp((int)gridX, (int)0, (int)2);
        gridZ = Mth.clamp((int)gridZ, (int)0, (int)2);
        int slot = gridZ * 3 + gridX;
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof DisplayerBlockEntity)) {
            return InteractionResult.PASS;
        }
        DisplayerBlockEntity displayer = (DisplayerBlockEntity)be;
        ItemStack held = player.getItemInHand(hand);
        ItemStack slotItem = displayer.getItem(slot);
        if (!held.isEmpty()) {
            if (slotItem.isEmpty()) {
                displayer.setItem(slot, held);
            } else if (held.getItem() == slotItem.getItem()) {
                if (held.getCount() < held.getMaxStackSize()) {
                    held.setCount(held.getCount() + 1);
                    displayer.setItem(slot, ItemStack.EMPTY);
                }
            } else if (held.getCount() == 1) {
                player.setItemInHand(hand, slotItem);
                displayer.setItem(slot, held);
            }
        } else if (!slotItem.isEmpty()) {
            player.setItemInHand(hand, slotItem);
            displayer.setItem(slot, ItemStack.EMPTY);
        }
        boolean lit = displayer.isLit();
        if (lit != (Boolean)blockState.getValue((Property)LIT)) {
            world.setBlock(pos, (BlockState)blockState.setValue((Property)LIT, (Comparable)Boolean.valueOf(lit)), 10);
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.getBlock() != newState.getBlock() && (tileEntity = worldIn.getBlockEntity(pos)) instanceof DisplayerBlockEntity) {
            DisplayerBlockEntity displayerEntity = (DisplayerBlockEntity)tileEntity;
            displayerEntity.removeAllItems().forEach(itemStack -> Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack));
        }
        super.onRemove(oldState, worldIn, pos, newState, isMoving);
    }

    public abstract double getDisplayerX(BlockState var1);

    public abstract double getDisplayerY(BlockState var1);

    public abstract double getDisplayerZ(BlockState var1);

    @Override
    public float getDisplayScale() {
        return 0.2f;
    }
}

