/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftime.dawnoftime.block.templates.SlabBlockDoT;

public class MixedSlabBlock
extends SlabBlockDoT {
    private final ArrayList<MixedBlockRecipe> listRecipes = new ArrayList();

    public MixedSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MixedSlabBlock addMixedBlockRecipe(Block secondSlab, Supplier<Block> mixedBlock, boolean thisSlabIsBottom) {
        return this.addMixedBlockRecipe(() -> secondSlab, mixedBlock, thisSlabIsBottom);
    }

    private MixedSlabBlock addMixedBlockRecipe(Supplier<Block> secondSlab, Supplier<Block> mixedBlock, boolean thisSlabIsBottom) {
        this.listRecipes.add(new MixedBlockRecipe(secondSlab, mixedBlock, thisSlabIsBottom));
        return this;
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Direction facing = hit.getDirection();
        ItemStack itemStack = player.getItemInHand(handIn);
        if (!player.isCrouching() && player.mayUseItemAt(pos, facing, itemStack) && facing.getAxis().isVertical() && !itemStack.isEmpty()) {
            for (MixedBlockRecipe recipe : this.listRecipes) {
                BlockState madeState;
                if (facing != recipe.getFacingForMerging(false) || !recipe.isConnectibleFirstSlab(state) || itemStack.getItem() != recipe.getSecondSlab().asItem() || !worldIn.setBlock(pos, madeState = recipe.getMixedBlock().defaultBlockState(), 11)) continue;
                this.setPlacedBy(worldIn, pos, state, (LivingEntity)player, itemStack);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, pos, itemStack);
                }
                SoundType soundtype = recipe.getMixedBlock().getSoundType(state);
                worldIn.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.use(state, worldIn, pos, player, handIn, hit);
    }

    public static Item getBlockItem(final MixedSlabBlock block) {
        return new BlockItem((Block)block, new Item.Properties()){

            public InteractionResult place(BlockPlaceContext context) {
                Direction facing = context.getClickedFace();
                if (context.getPlayer() != null && context.getPlayer().isCrouching() || !facing.getAxis().isVertical()) {
                    return super.place(context);
                }
                Player player = context.getPlayer();
                ItemStack itemStack = context.getItemInHand();
                Level worldIn = context.getLevel();
                BlockPos pos = context.getClickedPos();
                if (!context.replacingClickedOnBlock()) {
                    pos = pos.relative(facing.getOpposite());
                }
                if (player != null && !player.mayUseItemAt(pos, facing, itemStack)) {
                    return super.place(context);
                }
                if (!itemStack.isEmpty()) {
                    BlockState state = worldIn.getBlockState(pos);
                    for (MixedBlockRecipe recipe : block.listRecipes) {
                        BlockState madeState;
                        if (facing != recipe.getFacingForMerging(true) || !recipe.isConnectibleSecondSlab(state) || (madeState = recipe.getMixedBlock().getStateForPlacement(context)) == null || !worldIn.setBlock(pos, madeState, 11)) continue;
                        this.getBlock().setPlacedBy(worldIn, pos, state, (LivingEntity)player, itemStack);
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, pos, itemStack);
                        }
                        SoundType soundtype = recipe.getMixedBlock().getSoundType(state);
                        worldIn.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                        itemStack.shrink(1);
                        return InteractionResult.SUCCESS;
                    }
                }
                return super.place(context);
            }
        };
    }

    public static class MixedBlockRecipe {
        private final Supplier<Block> secondSlab;
        private final Supplier<Block> mixedBlock;
        private final boolean firstSlabIsBottom;

        private MixedBlockRecipe(Supplier<Block> secondSlab, Supplier<Block> mixedBlock, boolean firstSlabIsBottom) {
            this.secondSlab = secondSlab;
            this.mixedBlock = mixedBlock;
            this.firstSlabIsBottom = firstSlabIsBottom;
        }

        private boolean isConnectibleFirstSlab(BlockState state) {
            return this.firstSlabIsBottom ? state.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM : state.getValue((Property)SlabBlock.TYPE) == SlabType.TOP;
        }

        private boolean isConnectibleSecondSlab(BlockState state) {
            if (state.getBlock() == this.secondSlab.get() && this.secondSlab.get() instanceof SlabBlock) {
                return this.firstSlabIsBottom ? state.getValue((Property)SlabBlock.TYPE) == SlabType.TOP : state.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM;
            }
            return false;
        }

        private Direction getFacingForMerging(boolean tryPlacingFirstSlab) {
            if (tryPlacingFirstSlab) {
                return this.firstSlabIsBottom ? Direction.DOWN : Direction.UP;
            }
            return this.firstSlabIsBottom ? Direction.UP : Direction.DOWN;
        }

        protected Block getSecondSlab() {
            return this.secondSlab.get();
        }

        protected Block getMixedBlock() {
            return this.mixedBlock.get();
        }
    }
}

