/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_10;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2389;
import net.minecraft.class_2415;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2544;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4778;
import net.minecraft.class_4970;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;

public class CappedWallBlock
extends class_2248
implements class_3737 {
    public static final class_2754<class_4778> PILLAR = BlockStatePropertiesAA.PILLAR_WALL;
    public static final class_2754<class_4778> EAST_WALL = class_2741.field_22174;
    public static final class_2754<class_4778> NORTH_WALL = class_2741.field_22175;
    public static final class_2754<class_4778> SOUTH_WALL = class_2741.field_22176;
    public static final class_2754<class_4778> WEST_WALL = class_2741.field_22177;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private final Map<class_2680, class_265> shapeByIndex;
    private final Map<class_2680, class_265> collisionShapeByIndex;
    private static final class_265 POST_TEST = class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final class_265 NORTH_TEST = class_2248.method_9541((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final class_265 SOUTH_TEST = class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_TEST = class_2248.method_9541((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final class_265 EAST_TEST = class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    public CappedWallBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PILLAR, (Comparable)class_4778.field_22179)).method_11657(NORTH_WALL, (Comparable)class_4778.field_22178)).method_11657(EAST_WALL, (Comparable)class_4778.field_22178)).method_11657(SOUTH_WALL, (Comparable)class_4778.field_22178)).method_11657(WEST_WALL, (Comparable)class_4778.field_22178)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeByIndex = this.makeShapes(16.0f, 14.0f);
        this.collisionShapeByIndex = this.makeShapes(24.0f, 24.0f);
    }

    private static class_265 applyWallShape(class_265 mainShape, class_4778 height, class_265 newShape, class_265 p_235631_3_) {
        if (height == class_4778.field_22180) {
            return class_259.method_1084((class_265)mainShape, (class_265)p_235631_3_);
        }
        return height == class_4778.field_22179 ? class_259.method_1084((class_265)mainShape, (class_265)newShape) : mainShape;
    }

    private Map<class_2680, class_265> makeShapes(float sizePillarVertical, float sizeWallVertical) {
        float sizePillarStart = 4.0f;
        float sizePillarEnd = 12.0f;
        float sizeWallStart = 5.0f;
        float sizeWallEnd = 11.0f;
        class_265 voxelshape = class_2248.method_9541((double)sizePillarStart, (double)0.0, (double)sizePillarStart, (double)sizePillarEnd, (double)sizePillarVertical, (double)sizePillarEnd);
        class_265 voxelshape1 = class_2248.method_9541((double)sizeWallStart, (double)0.0, (double)0.0, (double)sizeWallEnd, (double)sizeWallVertical, (double)sizeWallEnd);
        class_265 voxelshape2 = class_2248.method_9541((double)sizeWallStart, (double)0.0, (double)sizeWallStart, (double)sizeWallEnd, (double)sizeWallVertical, (double)16.0);
        class_265 voxelshape3 = class_2248.method_9541((double)0.0, (double)0.0, (double)sizeWallStart, (double)sizeWallEnd, (double)sizeWallVertical, (double)sizeWallEnd);
        class_265 voxelshape4 = class_2248.method_9541((double)sizeWallStart, (double)0.0, (double)sizeWallStart, (double)16.0, (double)sizeWallVertical, (double)sizeWallEnd);
        class_265 voxelshape5 = class_2248.method_9541((double)sizeWallStart, (double)0.0, (double)0.0, (double)sizeWallEnd, (double)sizePillarVertical, (double)sizeWallEnd);
        class_265 voxelshape6 = class_2248.method_9541((double)sizeWallStart, (double)0.0, (double)sizeWallStart, (double)sizeWallEnd, (double)sizePillarVertical, (double)16.0);
        class_265 voxelshape7 = class_2248.method_9541((double)0.0, (double)0.0, (double)sizeWallStart, (double)sizeWallEnd, (double)sizePillarVertical, (double)sizeWallEnd);
        class_265 voxelshape8 = class_2248.method_9541((double)sizeWallStart, (double)0.0, (double)sizeWallStart, (double)16.0, (double)sizePillarVertical, (double)sizeWallEnd);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (class_4778 pillarStates : PILLAR.method_11898()) {
            for (class_4778 eastState : EAST_WALL.method_11898()) {
                for (class_4778 northState : NORTH_WALL.method_11898()) {
                    for (class_4778 westState : WEST_WALL.method_11898()) {
                        for (class_4778 southState : SOUTH_WALL.method_11898()) {
                            class_265 mainShape = class_259.method_1073();
                            mainShape = CappedWallBlock.applyWallShape(mainShape, eastState, voxelshape4, voxelshape8);
                            mainShape = CappedWallBlock.applyWallShape(mainShape, westState, voxelshape3, voxelshape7);
                            mainShape = CappedWallBlock.applyWallShape(mainShape, northState, voxelshape1, voxelshape5);
                            mainShape = CappedWallBlock.applyWallShape(mainShape, southState, voxelshape2, voxelshape6);
                            if (pillarStates != class_4778.field_22178) {
                                mainShape = class_259.method_1084((class_265)mainShape, (class_265)voxelshape);
                            }
                            class_2680 blockstate = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(PILLAR, (Comparable)pillarStates)).method_11657(EAST_WALL, (Comparable)eastState)).method_11657(WEST_WALL, (Comparable)westState)).method_11657(NORTH_WALL, (Comparable)northState)).method_11657(SOUTH_WALL, (Comparable)southState);
                            builder.put((Object)((class_2680)blockstate.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)mainShape);
                            builder.put((Object)((class_2680)blockstate.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)mainShape);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapeByIndex.get(state);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.collisionShapeByIndex.get(state);
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 pathType) {
        return false;
    }

    private boolean connectsTo(class_2680 state, boolean p_220113_2_, class_2350 direction) {
        class_2248 block = state.method_26204();
        boolean flag = block instanceof class_2349 && class_2349.method_16703((class_2680)state, (class_2350)direction);
        return state.method_26164(class_3481.field_15504) || !CappedWallBlock.method_9581((class_2680)state) && p_220113_2_ || block instanceof class_2389 || flag;
    }

    public class_2680 method_9605(class_1750 context) {
        class_1937 world = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        class_3610 fluidstate = context.method_8045().method_8316(context.method_8037());
        class_2338 posNorth = clickedPos.method_10095();
        class_2338 posEast = clickedPos.method_10078();
        class_2338 posSouth = clickedPos.method_10072();
        class_2338 posWest = clickedPos.method_10067();
        class_2338 posAbove = clickedPos.method_10084();
        class_2680 blockstate = world.method_8320(posNorth);
        class_2680 blockstate1 = world.method_8320(posEast);
        class_2680 blockstate2 = world.method_8320(posSouth);
        class_2680 blockstate3 = world.method_8320(posWest);
        class_2680 blockstate4 = world.method_8320(posAbove);
        boolean connectsSouth = this.connectsTo(blockstate, blockstate.method_26206((class_1922)world, posNorth, class_2350.field_11035), class_2350.field_11035);
        boolean connectsWest = this.connectsTo(blockstate1, blockstate1.method_26206((class_1922)world, posEast, class_2350.field_11039), class_2350.field_11039);
        boolean connectsNorth = this.connectsTo(blockstate2, blockstate2.method_26206((class_1922)world, posSouth, class_2350.field_11043), class_2350.field_11043);
        boolean connectsEast = this.connectsTo(blockstate3, blockstate3.method_26206((class_1922)world, posWest, class_2350.field_11034), class_2350.field_11034);
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.method_15772() == class_3612.field_15910));
        return this.updateShape((class_4538)world, state, posAbove, blockstate4, connectsSouth, connectsWest, connectsNorth, connectsEast);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 p_196271_3_, class_1936 world, class_2338 pos, class_2338 p_196271_6_) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (direction == class_2350.field_11033) {
            return super.method_9559(state, direction, p_196271_3_, world, pos, p_196271_6_);
        }
        return direction == class_2350.field_11036 ? this.topUpdate((class_4538)world, state, p_196271_6_, p_196271_3_) : this.sideUpdate((class_4538)world, pos, state, p_196271_6_, p_196271_3_, direction);
    }

    private static boolean isConnected(class_2680 p_235629_0_, class_2769<class_4778> p_235629_1_) {
        return p_235629_0_.method_11654(p_235629_1_) != class_4778.field_22178;
    }

    private static boolean isCovered(class_265 p_235632_0_, class_265 p_235632_1_) {
        return !class_259.method_1074((class_265)p_235632_1_, (class_265)p_235632_0_, (class_247)class_247.field_16886);
    }

    private class_2680 topUpdate(class_4538 p_235625_1_, class_2680 p_235625_2_, class_2338 p_235625_3_, class_2680 p_235625_4_) {
        boolean flag = CappedWallBlock.isConnected(p_235625_2_, NORTH_WALL);
        boolean flag1 = CappedWallBlock.isConnected(p_235625_2_, EAST_WALL);
        boolean flag2 = CappedWallBlock.isConnected(p_235625_2_, SOUTH_WALL);
        boolean flag3 = CappedWallBlock.isConnected(p_235625_2_, WEST_WALL);
        return this.updateShape(p_235625_1_, p_235625_2_, p_235625_3_, p_235625_4_, flag, flag1, flag2, flag3);
    }

    private class_2680 sideUpdate(class_4538 p_235627_1_, class_2338 p_235627_2_, class_2680 p_235627_3_, class_2338 p_235627_4_, class_2680 p_235627_5_, class_2350 p_235627_6_) {
        class_2350 direction = p_235627_6_.method_10153();
        boolean flag = p_235627_6_ == class_2350.field_11043 ? this.connectsTo(p_235627_5_, p_235627_5_.method_26206((class_1922)p_235627_1_, p_235627_4_, direction), direction) : CappedWallBlock.isConnected(p_235627_3_, NORTH_WALL);
        boolean flag1 = p_235627_6_ == class_2350.field_11034 ? this.connectsTo(p_235627_5_, p_235627_5_.method_26206((class_1922)p_235627_1_, p_235627_4_, direction), direction) : CappedWallBlock.isConnected(p_235627_3_, EAST_WALL);
        boolean flag2 = p_235627_6_ == class_2350.field_11035 ? this.connectsTo(p_235627_5_, p_235627_5_.method_26206((class_1922)p_235627_1_, p_235627_4_, direction), direction) : CappedWallBlock.isConnected(p_235627_3_, SOUTH_WALL);
        boolean flag3 = p_235627_6_ == class_2350.field_11039 ? this.connectsTo(p_235627_5_, p_235627_5_.method_26206((class_1922)p_235627_1_, p_235627_4_, direction), direction) : CappedWallBlock.isConnected(p_235627_3_, WEST_WALL);
        class_2338 blockpos = p_235627_2_.method_10084();
        class_2680 blockstate = p_235627_1_.method_8320(blockpos);
        return this.updateShape(p_235627_1_, p_235627_3_, blockpos, blockstate, flag, flag1, flag2, flag3);
    }

    private class_2680 updateShape(class_4538 world, class_2680 state, class_2338 pos, class_2680 stateTop, boolean p_235626_5_, boolean p_235626_6_, boolean p_235626_7_, boolean p_235626_8_) {
        class_265 voxelshape = stateTop.method_26220((class_1922)world, pos).method_20538(class_2350.field_11033);
        class_2680 blockstate = this.updateSides(state, p_235626_5_, p_235626_6_, p_235626_7_, p_235626_8_, voxelshape);
        return (class_2680)blockstate.method_11657(PILLAR, (Comparable)this.shouldRaisePost(blockstate, stateTop, voxelshape));
    }

    private class_4778 shouldRaisePost(class_2680 state, class_2680 stateTop, class_265 shape) {
        boolean flag6;
        boolean flag5;
        boolean flag;
        boolean bl = flag = stateTop.method_26204() instanceof class_2544 && (Boolean)stateTop.method_11654((class_2769)class_2544.field_11717) != false;
        if (flag) {
            return this.getPillarState(stateTop);
        }
        class_4778 wallSide = (class_4778)state.method_11654(NORTH_WALL);
        class_4778 wallSide1 = (class_4778)state.method_11654(SOUTH_WALL);
        class_4778 wallSide2 = (class_4778)state.method_11654(EAST_WALL);
        class_4778 wallSide3 = (class_4778)state.method_11654(WEST_WALL);
        boolean flag1 = wallSide1 == class_4778.field_22178;
        boolean flag2 = wallSide3 == class_4778.field_22178;
        boolean flag3 = wallSide2 == class_4778.field_22178;
        boolean flag4 = wallSide == class_4778.field_22178;
        boolean bl2 = flag5 = flag4 && flag1 && flag2 && flag3 || flag4 != flag1 || flag2 != flag3;
        if (flag5) {
            return this.getPillarState(stateTop);
        }
        boolean bl3 = flag6 = wallSide == class_4778.field_22180 && wallSide1 == class_4778.field_22180 || wallSide2 == class_4778.field_22180 && wallSide3 == class_4778.field_22180;
        if (flag6) {
            return class_4778.field_22178;
        }
        return stateTop.method_26164(class_3481.field_22276) || CappedWallBlock.isCovered(shape, POST_TEST) ? this.getPillarState(stateTop) : class_4778.field_22178;
    }

    private class_4778 getPillarState(class_2680 stateTop) {
        return stateTop.method_26164(class_3481.field_15504) ? class_4778.field_22179 : class_4778.field_22180;
    }

    private class_2680 updateSides(class_2680 state, boolean p_235630_2_, boolean p_235630_3_, boolean p_235630_4_, boolean p_235630_5_, class_265 p_235630_6_) {
        return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH_WALL, (Comparable)this.makeWallState(p_235630_2_, p_235630_6_, NORTH_TEST))).method_11657(EAST_WALL, (Comparable)this.makeWallState(p_235630_3_, p_235630_6_, EAST_TEST))).method_11657(SOUTH_WALL, (Comparable)this.makeWallState(p_235630_4_, p_235630_6_, SOUTH_TEST))).method_11657(WEST_WALL, (Comparable)this.makeWallState(p_235630_5_, p_235630_6_, WEST_TEST));
    }

    private class_4778 makeWallState(boolean p_235633_1_, class_265 shape, class_265 p_235633_3_) {
        if (p_235633_1_) {
            return CappedWallBlock.isCovered(shape, p_235633_3_) ? class_4778.field_22180 : class_4778.field_22179;
        }
        return class_4778.field_22178;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) == false;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> container) {
        container.method_11667(new class_2769[]{PILLAR, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED});
    }

    public class_2680 method_9598(class_2680 p_185499_1_, class_2470 p_185499_2_) {
        switch (p_185499_2_) {
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)p_185499_1_.method_11657(NORTH_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(SOUTH_WALL)))).method_11657(EAST_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(WEST_WALL)))).method_11657(SOUTH_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(NORTH_WALL)))).method_11657(WEST_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(EAST_WALL)));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)p_185499_1_.method_11657(NORTH_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(EAST_WALL)))).method_11657(EAST_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(SOUTH_WALL)))).method_11657(SOUTH_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(WEST_WALL)))).method_11657(WEST_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(NORTH_WALL)));
            }
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)p_185499_1_.method_11657(NORTH_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(WEST_WALL)))).method_11657(EAST_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(NORTH_WALL)))).method_11657(SOUTH_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(EAST_WALL)))).method_11657(WEST_WALL, (Comparable)((class_4778)p_185499_1_.method_11654(SOUTH_WALL)));
            }
        }
        return p_185499_1_;
    }

    public class_2680 method_9569(class_2680 p_185471_1_, class_2415 p_185471_2_) {
        switch (p_185471_2_) {
            case field_11300: {
                return (class_2680)((class_2680)p_185471_1_.method_11657(NORTH_WALL, (Comparable)((class_4778)p_185471_1_.method_11654(SOUTH_WALL)))).method_11657(SOUTH_WALL, (Comparable)((class_4778)p_185471_1_.method_11654(NORTH_WALL)));
            }
            case field_11301: {
                return (class_2680)((class_2680)p_185471_1_.method_11657(EAST_WALL, (Comparable)((class_4778)p_185471_1_.method_11654(WEST_WALL)))).method_11657(WEST_WALL, (Comparable)((class_4778)p_185471_1_.method_11654(EAST_WALL)));
            }
        }
        return super.method_9569(p_185471_1_, p_185471_2_);
    }
}

