/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class PortcullisBlock
extends WaterloggedBlock {
    private static final class_2746 OPEN = class_2741.field_12537;
    private static final class_2746 POWERED = class_2741.field_12484;
    private static final class_2754<class_2350.class_2351> HORIZONTAL_AXIS = class_2741.field_12529;
    private static final class_2754<BlockStatePropertiesAA.VerticalConnection> VERTICAL_CONNECTION = BlockStatePropertiesAA.VERTICAL_CONNECTION;

    public PortcullisBlock(class_4970.class_2251 properties) {
        super(properties, VoxelShapes.PORTCULLIS_SHAPES);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657(HORIZONTAL_AXIS, (Comparable)class_2350.class_2351.field_11048)).method_11657(VERTICAL_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.VerticalConnection.NONE)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{OPEN, POWERED, HORIZONTAL_AXIS, VERTICAL_CONNECTION});
    }

    @Override
    public int getShapeIndex(@NotNull class_2680 state, @NotNull class_1922 worldIn, @NotNull class_2338 pos, @NotNull class_3726 context) {
        if (((Boolean)state.method_11654((class_2769)OPEN)).booleanValue() && state.method_11654(VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.NONE && state.method_11654(VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.UNDER) {
            return 0;
        }
        return state.method_11654(HORIZONTAL_AXIS) == class_2350.class_2351.field_11048 ? 1 : 2;
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        state = (class_2680)state.method_11657(HORIZONTAL_AXIS, (Comparable)(context.method_8042().method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048));
        return this.getShape(state, (class_4538)context.method_8045(), context.method_8037());
    }

    @Override
    @NotNull
    protected class_2680 method_9559(class_2680 stateIn, class_4538 worldIn, class_10225 scheduledTickAccess, class_2338 currentPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        stateIn = super.method_9559(stateIn, worldIn, scheduledTickAccess, currentPos, direction, neighborPos, neighborState, random);
        return this.getShape(stateIn, worldIn, currentPos);
    }

    private class_2680 getShape(class_2680 state, class_4538 worldIn, class_2338 pos) {
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(HORIZONTAL_AXIS);
        if (this.hasSameAxis(worldIn.method_8320(pos.method_10084()), axis)) {
            return (class_2680)state.method_11657(VERTICAL_CONNECTION, (Comparable)((Object)(this.hasSameAxis(worldIn.method_8320(pos.method_10074()), axis) ? BlockStatePropertiesAA.VerticalConnection.BOTH : BlockStatePropertiesAA.VerticalConnection.ABOVE)));
        }
        return (class_2680)state.method_11657(VERTICAL_CONNECTION, (Comparable)((Object)(this.hasSameAxis(worldIn.method_8320(pos.method_10074()), axis) ? BlockStatePropertiesAA.VerticalConnection.UNDER : BlockStatePropertiesAA.VerticalConnection.NONE)));
    }

    private boolean hasSameAxis(class_2680 state, class_2350.class_2351 axis) {
        if (state.method_26204() instanceof PortcullisBlock) {
            return state.method_11654(HORIZONTAL_AXIS) == axis;
        }
        return false;
    }

    protected void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, @Nullable class_9904 orientation, boolean isMoving) {
        class_2350.class_2351 axis;
        if (state.method_11654(VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.UNDER) {
            class_2350.class_2351 axis2 = (class_2350.class_2351)state.method_11654(HORIZONTAL_AXIS);
            boolean isNowPowered = worldIn.method_49803(pos);
            if (((Boolean)state.method_11654((class_2769)OPEN)).booleanValue()) {
                if (this.isInSamePlane(pos, orientation, axis2) && isNowPowered) {
                    this.setOpenState(worldIn, pos, axis2, true);
                }
            } else if (isNowPowered) {
                this.setOpenState(worldIn, pos, axis2, true);
                state = (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(true));
            }
            if (!isNowPowered && ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
                state = (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false));
                worldIn.method_8652(pos, state, 2);
                if (!this.hasAnotherPowerSource(worldIn, pos, axis2)) {
                    this.setOpenState(worldIn, pos, axis2, false);
                }
            }
            if (isNowPowered != (Boolean)state.method_11654((class_2769)POWERED)) {
                state = (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(isNowPowered));
                worldIn.method_8652(pos, state, 2);
            }
        } else if (state.method_11654(VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.NONE) {
            if (((Boolean)state.method_11654((class_2769)OPEN)).booleanValue()) {
                worldIn.method_8652(pos, (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false)), 2);
            }
        } else if (((Boolean)state.method_11654((class_2769)OPEN)).booleanValue() && this.isInSamePlane(pos, orientation, axis = (class_2350.class_2351)state.method_11654(HORIZONTAL_AXIS))) {
            pos = this.getTopPortcullisPos(worldIn, pos, axis);
            worldIn.method_8320(pos).method_26181(worldIn, pos, blockIn, orientation, isMoving);
        }
    }

    private boolean isInSamePlane(class_2338 pos, class_9904 orientation, class_2350.class_2351 axis) {
        if (orientation == null) {
            return false;
        }
        return axis.method_10176(orientation.method_61854());
    }

    private class_2338 getTopPortcullisPos(class_1937 worldIn, class_2338 pos, class_2350.class_2351 axis) {
        boolean isStillPortcullis = true;
        while (isStillPortcullis) {
            class_2680 state = worldIn.method_8320(pos);
            if (state.method_26204() instanceof PortcullisBlock) {
                if (!this.hasSameAxis(state, axis)) {
                    isStillPortcullis = false;
                }
            } else {
                isStillPortcullis = false;
            }
            pos = pos.method_10084();
        }
        return pos.method_10074();
    }

    private boolean hasAnotherPowerSource(class_1937 worldIn, class_2338 pos, class_2350.class_2351 axis) {
        boolean isAxisX = axis == class_2350.class_2351.field_11048;
        class_2350 direction = isAxisX ? class_2350.field_11039 : class_2350.field_11043;
        int widthLeft = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? class_2350.field_11034 : class_2350.field_11035);
        int widthRight = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? class_2350.field_11039 : class_2350.field_11043);
        pos = pos.method_10079(direction, -widthLeft);
        for (int i = 0; i <= widthLeft + widthRight; ++i) {
            class_2680 state = worldIn.method_8320(pos.method_10079(direction, i));
            if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void setOpenState(class_1937 worldIn, class_2338 pos, class_2350.class_2351 axis, boolean openState) {
        class_2680 state;
        boolean isAxisX = axis == class_2350.class_2351.field_11048;
        class_2350 direction = isAxisX ? class_2350.field_11039 : class_2350.field_11043;
        int height = this.getPortcullisHeight(worldIn, pos, axis);
        int widthLeft = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? class_2350.field_11034 : class_2350.field_11035);
        int widthRight = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? class_2350.field_11039 : class_2350.field_11043);
        if (height > 16 || widthLeft + widthRight + 1 > 16) {
            return;
        }
        if (openState) {
            int vertical;
            int horizontal;
            for (horizontal = 1; horizontal <= widthLeft; ++horizontal) {
                for (vertical = 0; vertical < height; ++vertical) {
                    state = worldIn.method_8320(pos.method_10079(isAxisX ? class_2350.field_11034 : class_2350.field_11035, horizontal).method_10087(vertical));
                    if (state.method_26204() instanceof PortcullisBlock) {
                        if (state.method_11654(HORIZONTAL_AXIS) == axis) continue;
                        openState = false;
                        break;
                    }
                    openState = false;
                    break;
                }
                if (!openState) break;
            }
            if (openState) {
                for (horizontal = 1; horizontal <= widthRight; ++horizontal) {
                    for (vertical = 0; vertical < height; ++vertical) {
                        state = worldIn.method_8320(pos.method_10079(direction, horizontal).method_10087(vertical));
                        if (state.method_26204() instanceof PortcullisBlock) {
                            if (state.method_11654(HORIZONTAL_AXIS) == axis) continue;
                            openState = false;
                            break;
                        }
                        openState = false;
                        break;
                    }
                    if (!openState) break;
                }
            }
            if (openState) {
                openState = this.isCorrectBorder(worldIn, pos.method_10079(direction, -widthLeft).method_10084(), axis, isAxisX ? class_2350.field_11039 : class_2350.field_11043, widthLeft + widthRight);
                openState = openState && this.isCorrectBorder(worldIn, pos.method_10079(direction, -widthLeft).method_10087(height), axis, isAxisX ? class_2350.field_11039 : class_2350.field_11043, widthLeft + widthRight);
                openState = openState && this.isCorrectBorder(worldIn, pos.method_10079(direction, -widthLeft - 1), axis, class_2350.field_11033, height - 1);
                openState = openState && this.isCorrectBorder(worldIn, pos.method_10079(direction, widthRight + 1), axis, class_2350.field_11033, height - 1);
            }
        }
        pos = pos.method_10079(direction, -widthLeft);
        for (int horizontal = 0; horizontal < widthLeft + widthRight + 1; ++horizontal) {
            for (int vertical = 0; vertical < height; ++vertical) {
                class_2338 newPos = pos.method_10079(direction, horizontal).method_10087(vertical);
                state = worldIn.method_8320(newPos);
                if (!(state.method_26204() instanceof PortcullisBlock) || state.method_11654(HORIZONTAL_AXIS) != axis) continue;
                worldIn.method_8652(newPos, (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(openState)), 10);
                if (horizontal != widthLeft) continue;
                if (vertical == 0 && openState) {
                    worldIn.method_8444(null, this.getOpenSound(), newPos, 0);
                }
                if (vertical != height - 1 || openState) continue;
                worldIn.method_8444(null, this.getCloseSound(), newPos, 0);
            }
        }
    }

    private int getPortcullisHeight(class_1937 worldIn, class_2338 pos, class_2350.class_2351 axis) {
        int height = 0;
        boolean isSamePortcullis = true;
        while (isSamePortcullis) {
            class_2680 state = worldIn.method_8320(pos = pos.method_10074());
            if (state.method_26204() instanceof PortcullisBlock) {
                if (state.method_11654(HORIZONTAL_AXIS) != axis) {
                    isSamePortcullis = false;
                }
            } else {
                isSamePortcullis = false;
            }
            ++height;
        }
        return height;
    }

    private int getPortcullisWidth(class_1937 worldIn, class_2338 pos, class_2350.class_2351 axis, class_2350 direction) {
        int width = 0;
        boolean isSamePortcullis = true;
        while (isSamePortcullis) {
            class_2680 state = worldIn.method_8320(pos = pos.method_10093(direction));
            if (state.method_26204() instanceof PortcullisBlock) {
                if (state.method_11654(HORIZONTAL_AXIS) != axis) {
                    isSamePortcullis = false;
                }
            } else {
                isSamePortcullis = false;
            }
            ++width;
        }
        return width - 1;
    }

    private boolean isCorrectBorder(class_1937 worldIn, class_2338 pos, class_2350.class_2351 axis, class_2350 direction, int length) {
        for (int i = 0; i <= length; ++i) {
            class_2680 state = worldIn.method_8320(pos.method_10079(direction, i));
            if (!(state.method_26204() instanceof PortcullisBlock) || state.method_11654(HORIZONTAL_AXIS) != axis) continue;
            return false;
        }
        return true;
    }

    private int getCloseSound() {
        return 1011;
    }

    private int getOpenSound() {
        return 1005;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        if (rot == class_2470.field_11463 || rot == class_2470.field_11465) {
            return (class_2680)state.method_11657(HORIZONTAL_AXIS, (Comparable)(state.method_11654(HORIZONTAL_AXIS) == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048));
        }
        return super.method_9598(state, rot);
    }
}

