/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.general;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class FireplaceBlock
extends WaterloggedBlock {
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final EnumProperty<BlockStatePropertiesAA.HorizontalConnection> HORIZONTAL_CONNECTION = BlockStatePropertiesAA.HORIZONTAL_CONNECTION;

    public FireplaceBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.FIREPLACE_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).setValue(HORIZONTAL_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.HorizontalConnection.NONE)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HORIZONTAL_AXIS, LIT, HORIZONTAL_CONNECTION});
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape(state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? 1 : 3);
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X) {
            return (Boolean)state.getValue((Property)LIT) != false ? 0 : 1;
        }
        return (Boolean)state.getValue((Property)LIT) != false ? 2 : 3;
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)(stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos)).getValue((Property)WATERLOGGED)).booleanValue()) {
            stateIn = (BlockState)stateIn.setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        } else if (facing.getAxis() == stateIn.getValue(HORIZONTAL_AXIS) && facingState.getBlock() == this && !((Boolean)facingState.getValue((Property)WATERLOGGED)).booleanValue()) {
            stateIn = (BlockState)stateIn.setValue((Property)LIT, (Comparable)((Boolean)facingState.getValue((Property)LIT)));
        }
        return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : stateIn;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        return Utils.changeBlockLitStateWithItemOrCreativePlayer(state, worldIn, pos, player, player.getUsedItemHand()) >= 0 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public void onProjectileHit(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        int activation = -1;
        if (!((Boolean)state.getValue((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() && !((Boolean)state.getValue((Property)LIT)).booleanValue() && (projectile instanceof AbstractArrow && projectile.isOnFire() || projectile instanceof Fireball)) {
            activation = 1;
        } else if (((Boolean)state.getValue((Property)LIT)).booleanValue() && (projectile instanceof Snowball || projectile instanceof ThrownPotion && Utils.getPotionByName(Utils.getItemKeyAsString(((ThrowableItemProjectile)projectile).getItem().getItem())).getEffects().size() <= 0)) {
            activation = 0;
        }
        if (activation >= 0) {
            boolean isActivated;
            BlockPos pos = hit.getBlockPos();
            boolean bl = isActivated = activation == 1;
            if (!worldIn.isClientSide()) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(isActivated)), 10);
                worldIn.playSound(null, pos, isActivated ? SoundEvents.FIRE_AMBIENT : SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!isActivated && worldIn.isClientSide()) {
                for (int i = 0; i < worldIn.random.nextInt(1) + 1; ++i) {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (double)(worldIn.random.nextFloat() / 4.0f), 2.5E-5, (double)(worldIn.random.nextFloat() / 4.0f));
                }
            }
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entityIn) {
        if (!entityIn.fireImmune() && ((Boolean)state.getValue((Property)LIT)).booleanValue() && entityIn instanceof LivingEntity && EnchantmentHelper.getEnchantmentLevel((Holder)entityIn.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FROST_WALKER), (LivingEntity)((LivingEntity)entityIn)) <= 0) {
            entityIn.hurt(entityIn.damageSources().inFire(), 1.0f);
        }
        super.entityInside(state, world, pos, entityIn);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        Direction.Axis axis = context.getHorizontalDirection().getAxis() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return (BlockState)((BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)axis)).setValue(HORIZONTAL_CONNECTION, (Comparable)((Object)this.getHorizontalShape(context.getLevel(), context.getClickedPos(), axis)));
    }

    private BlockStatePropertiesAA.HorizontalConnection getHorizontalShape(Level worldIn, BlockPos pos, Direction.Axis axis) {
        boolean blockRight;
        BlockState left = worldIn.getBlockState(pos.relative(axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH, 1));
        BlockState right = worldIn.getBlockState(pos.relative(axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH, -1));
        boolean blockLeft = left.getBlock() instanceof FireplaceBlock;
        if (blockLeft) {
            boolean bl = blockLeft = left.getValue(HORIZONTAL_AXIS) == axis;
        }
        if (blockRight = right.getBlock() instanceof FireplaceBlock) {
            boolean bl = blockRight = right.getValue(HORIZONTAL_AXIS) == axis;
        }
        if (blockLeft) {
            return blockRight ? BlockStatePropertiesAA.HorizontalConnection.BOTH : BlockStatePropertiesAA.HorizontalConnection.LEFT;
        }
        return blockRight ? BlockStatePropertiesAA.HorizontalConnection.RIGHT : BlockStatePropertiesAA.HorizontalConnection.NONE;
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluid) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() || fluid.getType() != Fluids.WATER) {
            return false;
        }
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            world.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 10);
        world.scheduleTick(pos, fluid.getType(), fluid.getType().getTickDelay((LevelReader)world));
        return true;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (rand.nextInt(10) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (double)(rand.nextFloat() / 4.0f), 2.5E-5, (double)(rand.nextFloat() / 4.0f));
                }
            }
            worldIn.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)pos.getX() + 0.5 + rand.nextDouble() / 3.0 * (double)(rand.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5 + rand.nextDouble() / 3.0 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        Direction.Axis axis = (Direction.Axis)state.getValue(HORIZONTAL_AXIS);
        return rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90 ? (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X)) : state;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Utils.addTooltip(tooltipComponents, "fireplace");
    }
}

