/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.japanese;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;

public class CharredSpruceRailingBlock
extends FenceBlock {
    private static final EnumProperty<BlockStatePropertiesAA.FencePillar> FENCE_PILLAR = BlockStatePropertiesAA.FENCE_PILLAR;

    public CharredSpruceRailingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FENCE_PILLAR, (Comparable)((Object)BlockStatePropertiesAA.FencePillar.PILLAR_SMALL)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FENCE_PILLAR});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.getLevel();
        BlockState oldState = world.getBlockState(pos = context.getClickedPos());
        if (oldState.getBlock() == this && this.isSmallPillar(oldState)) {
            return (BlockState)oldState.setValue(FENCE_PILLAR, (Comparable)((Object)this.getBigPillar((LevelAccessor)world, pos)));
        }
        return super.getStateForPlacement(context);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (super.useWithoutItem(state, worldIn, pos, player, hit) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching()) {
            switch ((BlockStatePropertiesAA.FencePillar)((Object)state.getValue(FENCE_PILLAR))) {
                case PILLAR_BIG: 
                case CAP_PILLAR_BIG: {
                    if (!player.isCreative()) {
                        Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)this.asItem()));
                    }
                }
                case NONE: {
                    worldIn.setBlock(pos, (BlockState)state.setValue(FENCE_PILLAR, (Comparable)((Object)BlockStatePropertiesAA.FencePillar.PILLAR_SMALL)), 2);
                    break;
                }
                case PILLAR_SMALL: {
                    worldIn.setBlock(pos, (BlockState)state.setValue(FENCE_PILLAR, (Comparable)((Object)BlockStatePropertiesAA.FencePillar.NONE)), 2);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        if (useContext.getItemInHand().getItem() == this.asItem()) {
            if (useContext.getPlayer() != null && useContext.getPlayer().isCrouching()) {
                return super.canBeReplaced(state, useContext);
            }
            return this.isSmallPillar(state);
        }
        return super.canBeReplaced(state, useContext);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (facing == Direction.UP && !this.isSmallPillar(stateIn)) {
            stateIn = (BlockState)stateIn.setValue(FENCE_PILLAR, (Comparable)((Object)this.getBigPillar(worldIn, currentPos)));
        }
        return stateIn;
    }

    private boolean isSmallPillar(BlockState state) {
        return state.getValue(FENCE_PILLAR) == BlockStatePropertiesAA.FencePillar.NONE || state.getValue(FENCE_PILLAR) == BlockStatePropertiesAA.FencePillar.PILLAR_SMALL;
    }

    private BlockStatePropertiesAA.FencePillar getBigPillar(LevelAccessor world, BlockPos pos) {
        return world.getBlockState(pos = pos.above()).getCollisionShape((BlockGetter)world, pos).isEmpty() ? BlockStatePropertiesAA.FencePillar.CAP_PILLAR_BIG : BlockStatePropertiesAA.FencePillar.PILLAR_BIG;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Utils.addTooltip(tooltipComponents, (Block)this, new String[0]);
    }
}

