/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.japanese;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.jetbrains.annotations.NotNull;

public class CharredSpruceShuttersBlock
extends WaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;

    public CharredSpruceShuttersBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties.pushReaction(PushReaction.DESTROY), shapes);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, OPEN, POWERED});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = (Boolean)state.getValue((Property)OPEN) != false ? 1 : 0;
        return ((Direction)state.getValue((Property)FACING)).get2DDataValue() * 2 + index;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(world.hasNeighborSignal(pos)));
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)OPEN) == false));
        worldIn.setBlock(pos, state, 10);
        worldIn.levelEvent(player, (Boolean)state.getValue((Property)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return InteractionResult.SUCCESS;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean isPowered = worldIn.hasNeighborSignal(pos);
        if (blockIn != this && isPowered != (Boolean)state.getValue((Property)POWERED)) {
            if (isPowered != (Boolean)state.getValue((Property)OPEN)) {
                this.playSound(worldIn, pos, isPowered);
            }
            worldIn.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(isPowered)), 2);
        }
    }

    private void playSound(Level worldIn, BlockPos pos, boolean isOpening) {
        worldIn.levelEvent(null, isOpening ? this.getOpenSound() : this.getCloseSound(), pos, 0);
    }

    private int getCloseSound() {
        return 1012;
    }

    private int getOpenSound() {
        return 1006;
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, @NotNull Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

