/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.japanese;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.japanese.CharredSpruceShuttersBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class CharredSpruceTallShuttersBlock
extends CharredSpruceShuttersBlock {
    public static final EnumProperty<BlockStatePropertiesAA.SquareCorners> CORNER = BlockStatePropertiesAA.CORNER;

    public CharredSpruceTallShuttersBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.CHARRED_SPRUCE_TALL_SHUTTERS_SHAPES);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(CORNER, (Comparable)((Object)BlockStatePropertiesAA.SquareCorners.TOP_LEFT)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CORNER});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = ((Boolean)state.getValue((Property)OPEN)).booleanValue() ? (((BlockStatePropertiesAA.SquareCorners)((Object)state.getValue(CORNER))).isTopCorner() ? 1 : 2) : 0;
        return ((Direction)state.getValue((Property)FACING)).get2DDataValue() * 3 + index;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getHorizontalDirection();
        BlockPos posRight = pos.relative(facing.getClockWise());
        boolean right = world.getBlockState(posRight).canBeReplaced(context);
        BlockPos posLeft = pos.relative(facing.getCounterClockWise());
        boolean left = world.getBlockState(posLeft).canBeReplaced(context);
        if (!right && !left) {
            return null;
        }
        if (world.getBlockState(pos.above()).canBeReplaced(context)) {
            if (right && world.getBlockState(posRight.above()).canBeReplaced(context)) {
                return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue(CORNER, (Comparable)((Object)BlockStatePropertiesAA.SquareCorners.BOTTOM_LEFT))).setValue((Property)FACING, (Comparable)facing)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(world.hasNeighborSignal(pos)));
            }
            if (left && world.getBlockState(posLeft.above()).canBeReplaced(context)) {
                return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue(CORNER, (Comparable)((Object)BlockStatePropertiesAA.SquareCorners.BOTTOM_RIGHT))).setValue((Property)FACING, (Comparable)facing)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(world.hasNeighborSignal(pos)));
            }
        }
        if (world.getBlockState(pos.below()).canBeReplaced(context)) {
            if (right && world.getBlockState(posRight.below()).canBeReplaced(context)) {
                return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue(CORNER, (Comparable)((Object)BlockStatePropertiesAA.SquareCorners.TOP_LEFT))).setValue((Property)FACING, (Comparable)facing)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(world.hasNeighborSignal(pos)));
            }
            if (left && world.getBlockState(posLeft.below()).canBeReplaced(context)) {
                return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue(CORNER, (Comparable)((Object)BlockStatePropertiesAA.SquareCorners.TOP_RIGHT))).setValue((Property)FACING, (Comparable)facing)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(world.hasNeighborSignal(pos)));
            }
        }
        return null;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockStatePropertiesAA.SquareCorners thisCorner = (BlockStatePropertiesAA.SquareCorners)((Object)state.getValue(CORNER));
        Direction facing = (Direction)state.getValue((Property)FACING);
        for (BlockStatePropertiesAA.SquareCorners corner : BlockStatePropertiesAA.SquareCorners.values()) {
            if (thisCorner == corner) continue;
            BlockPos cornerPos = pos.above(corner.getVerticalOffset(thisCorner)).relative(facing.getClockWise(), corner.getHorizontalOffset(thisCorner));
            worldIn.setBlock(cornerPos, (BlockState)((BlockState)state.setValue(CORNER, (Comparable)((Object)corner))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.getFluidState(cornerPos).getType() == Fluids.WATER)), 10);
        }
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        BlockStatePropertiesAA.SquareCorners thisCorner = (BlockStatePropertiesAA.SquareCorners)((Object)stateIn.getValue(CORNER));
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        Direction currentFacing = (Direction)stateIn.getValue((Property)FACING);
        BlockStatePropertiesAA.SquareCorners expectedCorner = thisCorner.getAdjacentCorner(facing.getAxis().isVertical());
        if (currentPos.above(expectedCorner.getVerticalOffset(thisCorner)).relative(currentFacing.getClockWise(), expectedCorner.getHorizontalOffset(thisCorner)).equals((Object)facingPos)) {
            if (facingState.getBlock() == this && facingState.getValue(CORNER) == expectedCorner && facingState.getValue((Property)FACING) == currentFacing) {
                return (BlockState)stateIn.setValue((Property)OPEN, (Comparable)((Boolean)facingState.getValue((Property)OPEN)));
            }
            return Blocks.AIR.defaultBlockState();
        }
        return stateIn;
    }

    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos cornerPos;
        BlockState cornerState;
        BlockStatePropertiesAA.SquareCorners corner;
        if (!level.isClientSide() && player.isCreative() && (corner = (BlockStatePropertiesAA.SquareCorners)((Object)state.getValue(CORNER))) != BlockStatePropertiesAA.SquareCorners.TOP_LEFT && (cornerState = level.getBlockState(cornerPos = pos.above(BlockStatePropertiesAA.SquareCorners.TOP_LEFT.getVerticalOffset(corner)).relative(((Direction)state.getValue((Property)FACING)).getClockWise(), BlockStatePropertiesAA.SquareCorners.TOP_LEFT.getHorizontalOffset(corner)))).is((Block)this) && cornerState.getValue((Property)FACING) == state.getValue((Property)FACING) && cornerState.getValue(CORNER) == BlockStatePropertiesAA.SquareCorners.TOP_LEFT) {
            level.setBlock(cornerPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, cornerPos, Block.getId((BlockState)state));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }
}

