/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.roman;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.ChairBlock;
import org.dawnoftime.dawnoftime.entity.ChairEntity;
import org.jetbrains.annotations.NotNull;

public class BirchCouchBlock
extends ChairBlock {
    public BirchCouchBlock(BlockBehaviour.Properties properties, float pixelsYOffset, VoxelShape[] shapes) {
        super(properties.pushReaction(PushReaction.DESTROY), pixelsYOffset, shapes);
        this.defaultBlockState().setValue((Property)BlockStateProperties.PERSISTENT, (Comparable)Boolean.valueOf(true));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.PERSISTENT});
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        float x = 8.0f;
        float z = 8.0f;
        switch ((Direction)state.getValue((Property)FACING)) {
            case SOUTH: {
                z = 14.0f;
                break;
            }
            case WEST: {
                x = 2.0f;
                break;
            }
            case EAST: {
                x = 14.0f;
                break;
            }
            default: {
                z = 2.0f;
            }
        }
        return ChairEntity.createEntity(worldIn, pos, player, player.getDirection().getOpposite(), x, this.pixelsYOffset, z);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        if (context.getLevel().getBlockState(context.getClickedPos().relative(direction)).canBeReplaced(context)) {
            return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)direction);
        }
        return null;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Direction currentFacing = (Direction)state.getValue((Property)FACING);
        worldIn.setBlock(pos.relative(currentFacing), (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing.getOpposite())).setValue((Property)BlockStateProperties.PERSISTENT, (Comparable)Boolean.valueOf(false)), 3);
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Direction blockFacing = (Direction)stateIn.getValue((Property)FACING);
        if (facing == blockFacing) {
            if (facingState.getBlock() == this && ((Direction)facingState.getValue((Property)FACING)).getOpposite() == blockFacing) {
                return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        Direction dir;
        BlockPos adjacentPos;
        BlockState adjacentState;
        if (!level.isClientSide() && player.isCreative() && !((Boolean)state.getValue((Property)BlockStateProperties.PERSISTENT)).booleanValue() && (adjacentState = level.getBlockState(adjacentPos = pos.relative(dir = (Direction)state.getValue((Property)FACING)))).is((Block)this) && adjacentState.getValue((Property)FACING) == dir.getOpposite()) {
            level.setBlock(adjacentPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, adjacentPos, Block.getId((BlockState)state));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }
}

