/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.roman;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.IBlockPillar;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class MarbleColumnBlock
extends ConnectedVerticalBlock
implements IBlockPillar {
    public static final BooleanProperty AXIS_X = BlockStatePropertiesAA.AXIS_X;

    public MarbleColumnBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.MARBLE_COLUMN_SHAPES);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS_X});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((BlockStatePropertiesAA.VerticalConnection)((Object)state.getValue((Property)VERTICAL_CONNECTION))) {
            case BlockStatePropertiesAA.VerticalConnection.ABOVE -> 1;
            case BlockStatePropertiesAA.VerticalConnection.UNDER -> {
                if (((Boolean)state.getValue((Property)AXIS_X)).booleanValue()) {
                    yield 2;
                }
                yield 3;
            }
            default -> 0;
        };
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(context.getNearestLookingDirection().getAxis() == Direction.Axis.X));
    }

    @Override
    @Nonnull
    public BlockStatePropertiesAA.PillarConnection getBlockPillarConnectionAbove(BlockState state) {
        return BlockStatePropertiesAA.PillarConnection.EIGHT_PX;
    }

    @Override
    public boolean isConnectible(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, Direction faceToConnect) {
        BlockState testedState = worldIn.getBlockState(pos);
        if (faceToConnect == Direction.DOWN && IBlockPillar.getPillarConnectionUnder(worldIn, pos) == BlockStatePropertiesAA.PillarConnection.EIGHT_PX) {
            return true;
        }
        if (faceToConnect == Direction.UP && IBlockPillar.getPillarConnectionAbove(worldIn, pos) == BlockStatePropertiesAA.PillarConnection.EIGHT_PX) {
            return true;
        }
        return testedState.getBlock() == this;
    }
}

