/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.jetbrains.annotations.NotNull;

public class ConnectedVerticalBlock
extends WaterloggedBlock {
    public static final EnumProperty<BlockStatePropertiesAA.VerticalConnection> VERTICAL_CONNECTION = BlockStatePropertiesAA.VERTICAL_CONNECTION;

    public ConnectedVerticalBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(VERTICAL_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.VerticalConnection.NONE)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{VERTICAL_CONNECTION});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return ((BlockStatePropertiesAA.VerticalConnection)((Object)state.getValue(VERTICAL_CONNECTION))).getIndex();
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing.getAxis().isVertical() ? (BlockState)stateIn.setValue(VERTICAL_CONNECTION, (Comparable)((Object)this.getColumnState(worldIn, currentPos, stateIn))) : stateIn;
    }

    public BlockStatePropertiesAA.VerticalConnection getColumnState(LevelAccessor worldIn, BlockPos pos, BlockState stateIn) {
        if (this.isConnectible(stateIn, worldIn, pos.above(), Direction.DOWN)) {
            return this.isConnectible(stateIn, worldIn, pos.below(), Direction.UP) ? BlockStatePropertiesAA.VerticalConnection.BOTH : BlockStatePropertiesAA.VerticalConnection.ABOVE;
        }
        return this.isConnectible(stateIn, worldIn, pos.below(), Direction.UP) ? BlockStatePropertiesAA.VerticalConnection.UNDER : BlockStatePropertiesAA.VerticalConnection.NONE;
    }

    public boolean isConnectible(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, Direction faceToConnect) {
        return worldIn.getBlockState(pos).getBlock() == this;
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos topPos;
        ItemStack heldItemStack = player.getItemInHand(player.getUsedItemHand());
        if (player.isCrouching()) {
            if (state.getValue(VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.NONE) {
                return super.useWithoutItem(state, worldIn, pos, player, hit);
            }
            BlockPos topPos2 = this.getHighestColumnPos(worldIn, pos);
            if (topPos2 != pos) {
                if (!worldIn.isClientSide()) {
                    worldIn.setBlock(topPos2, Blocks.AIR.defaultBlockState(), 35);
                    if (!player.isCreative()) {
                        Block.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)heldItemStack);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (!heldItemStack.isEmpty() && heldItemStack.getItem() == this.asItem() && (topPos = this.getHighestColumnPos(worldIn, pos).above()).getY() <= 255 && worldIn.getBlockState(topPos).isAir()) {
            if (!worldIn.isClientSide()) {
                worldIn.setBlock(topPos, state, 11);
                if (!player.isCreative()) {
                    heldItemStack.shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, worldIn, pos, player, hit);
    }

    private BlockPos getHighestColumnPos(Level worldIn, BlockPos pos) {
        int yOffset = 0;
        while (yOffset + pos.getY() <= 255 && worldIn.getBlockState(pos.above(yOffset)).getBlock() == this) {
            ++yOffset;
        }
        return pos.above(yOffset - 1);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Utils.addTooltip(tooltipComponents, "column");
    }
}

