/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.ChairBlock;
import org.jetbrains.annotations.NotNull;

public class DoubleChairBlock
extends ChairBlock {
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;

    public DoubleChairBlock(BlockBehaviour.Properties properties, float offsetY, VoxelShape[] shapes) {
        super(properties, offsetY, shapes);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (!context.getLevel().getBlockState(context.getClickedPos().above()).canBeReplaced(context)) {
            return null;
        }
        return (BlockState)super.getStateForPlacement(context).setValue((Property)ChairBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)Half.TOP), 10);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (state.getValue(HALF) == Half.TOP) {
            return InteractionResult.PASS;
        }
        return super.useWithoutItem(state, worldIn, pos, player, hit);
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Direction halfDirection;
        Direction direction = halfDirection = stateIn.getValue(HALF) == Half.TOP ? Direction.DOWN : Direction.UP;
        if (facing == halfDirection && (facingState.getBlock() != this || facingState.getValue(HALF) == stateIn.getValue(HALF) || facingState.getValue((Property)ChairBlock.FACING) != stateIn.getValue((Property)ChairBlock.FACING))) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.getValue(HALF) != Half.TOP) {
            return true;
        }
        BlockState bottomState = worldIn.getBlockState(pos.below());
        if (bottomState.getBlock() == this) {
            return bottomState.getValue(HALF) == Half.BOTTOM && bottomState.getValue((Property)ChairBlock.FACING) == state.getValue((Property)ChairBlock.FACING);
        }
        return false;
    }

    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos adjacentPos;
        BlockState adjacentState;
        if (!level.isClientSide() && player.isCreative() && state.getValue(HALF) == Half.TOP && (adjacentState = level.getBlockState(adjacentPos = pos.below())).is((Block)this) && adjacentState.getValue(HALF) == Half.BOTTOM) {
            level.setBlock(adjacentPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, adjacentPos, Block.getId((BlockState)state));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = state.getValue(HALF) == Half.TOP ? 1 : 0;
        return ((Direction)state.getValue((Property)FACING)).get2DDataValue() * 2 + index;
    }
}

