/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class EdgeBlock
extends WaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;

    public EdgeBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)Half.BOTTOM)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    public EdgeBlock(BlockBehaviour.Properties properties) {
        this(properties, VoxelShapes.EDGE_SHAPES);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, HALF, SHAPE});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = (((Direction)state.getValue((Property)FACING)).get2DDataValue() + 2) % 4;
        index *= 3;
        switch ((StairsShape)state.getValue(SHAPE)) {
            default: {
                break;
            }
            case OUTER_RIGHT: {
                index += 3;
                break;
            }
            case STRAIGHT: {
                ++index;
                break;
            }
            case INNER_LEFT: {
                index += 2;
                break;
            }
            case INNER_RIGHT: {
                index += 5;
            }
        }
        return state.getValue(HALF) == Half.BOTTOM ? index : (index %= 12) + 12;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        Direction direction = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        state = (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HALF, (Comparable)(direction != Direction.DOWN && (direction == Direction.UP || context.getClickLocation().y - (double)pos.getY() <= 0.5) ? Half.BOTTOM : Half.TOP));
        return (BlockState)state.setValue(SHAPE, (Comparable)EdgeBlock.getShapeProperty(state, (LevelReader)context.getLevel(), pos));
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing.getAxis().isHorizontal() ? (BlockState)stateIn.setValue(SHAPE, (Comparable)EdgeBlock.getShapeProperty(stateIn, (LevelReader)worldIn, currentPos)) : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static StairsShape getShapeProperty(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction adjacentDirection;
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState adjacentState = worldIn.getBlockState(pos.relative(direction));
        if (EdgeBlock.isBlockEdge(adjacentState) && state.getValue(HALF) == adjacentState.getValue(HALF) && (adjacentDirection = (Direction)adjacentState.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && EdgeBlock.isDifferentEdge(state, worldIn, pos, adjacentDirection.getOpposite())) {
            return adjacentDirection == direction.getCounterClockWise() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        adjacentState = worldIn.getBlockState(pos.relative(direction.getOpposite()));
        if (EdgeBlock.isBlockEdge(adjacentState) && state.getValue(HALF) == adjacentState.getValue(HALF) && (adjacentDirection = (Direction)adjacentState.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && EdgeBlock.isDifferentEdge(state, worldIn, pos, adjacentDirection)) {
            return adjacentDirection == direction.getCounterClockWise() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentEdge(BlockState state, LevelReader worldIn, BlockPos pos, Direction face) {
        BlockState adjacentState = worldIn.getBlockState(pos.relative(face));
        return !EdgeBlock.isBlockEdge(adjacentState) || adjacentState.getValue((Property)FACING) != state.getValue((Property)FACING) || adjacentState.getValue(HALF) != state.getValue(HALF);
    }

    public static boolean isBlockEdge(BlockState state) {
        return state.getBlock() instanceof EdgeBlock;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.getValue(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                return switch (stairsshape) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return switch (stairsshape) {
                    default -> throw new MatchException(null, null);
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.mirror(state, mirrorIn);
    }
}

