/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.general.WaterSourceTrickleBlock;
import org.dawnoftime.dawnoftime.block.general.WaterTrickleBlock;
import org.dawnoftime.dawnoftime.block.templates.PoolBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class FaucetBlock
extends WaterSourceTrickleBlock {
    public FaucetBlock(BlockBehaviour.Properties propertiesIn) {
        super(propertiesIn);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStatePropertiesAA.ACTIVATED});
    }

    @Override
    public boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        return !ctx.isSecondaryUseActive() && ctx.getItemInHand().is(this.asItem());
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos pos;
        Level level = ctx.getLevel();
        BlockState current = level.getBlockState(pos = ctx.getClickedPos());
        BlockState out = current.is((Block)this) ? current : this.defaultBlockState();
        Direction target = FaucetBlock.pickHorizontalByLocalHit(pos, ctx.getClickLocation());
        return (BlockState)out.setValue((Property)FaucetBlock.prop(target), (Comparable)Boolean.valueOf(true));
    }

    private static BooleanProperty prop(Direction d) {
        return switch (d) {
            case Direction.NORTH -> BlockStateProperties.NORTH;
            case Direction.EAST -> BlockStateProperties.EAST;
            case Direction.SOUTH -> BlockStateProperties.SOUTH;
            case Direction.WEST -> BlockStateProperties.WEST;
            default -> BlockStateProperties.NORTH;
        };
    }

    private static Direction pickHorizontalByLocalHit(BlockPos pos, Vec3 worldHit) {
        double localX = worldHit.x - (double)pos.getX() - 0.5;
        double localZ = worldHit.z - (double)pos.getZ() - 0.5;
        if (Math.abs(localX) > Math.abs(localZ)) {
            return localX > 0.0 ? Direction.EAST : Direction.WEST;
        }
        return localZ > 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    @Override
    public boolean[] getWaterTrickleOutPut(BlockState currentState) {
        if (!((Boolean)currentState.getValue((Property)BlockStatePropertiesAA.ACTIVATED)).booleanValue()) {
            return new boolean[]{(Boolean)currentState.getValue((Property)BlockStatePropertiesAA.NORTH_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.EAST_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.SOUTH_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.WEST_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.CENTER_TRICKLE)};
        }
        return super.getWaterTrickleOutPut(currentState);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            world.playSound(player, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, 0.6f);
            world.playSound(player, pos, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
        boolean activated = (Boolean)state.getValue((Property)BlockStatePropertiesAA.ACTIVATED) == false;
        state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(activated));
        if (activated) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(true));
        }
        world.setBlock(pos, state, 10);
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction directionIn, BlockState facingStateIn, LevelAccessor worldIn, BlockPos currentPosIn, BlockPos facingPosIn) {
        BlockState state = super.updateShape(stateIn, directionIn, facingStateIn, worldIn, currentPosIn, facingPosIn);
        boolean lastActivation = (Boolean)state.getValue((Property)BlockStatePropertiesAA.ACTIVATED);
        switch (directionIn) {
            case NORTH: {
                Block block;
                if (!((Boolean)state.getValue((Property)BlockStateProperties.NORTH)).booleanValue() || !((block = facingStateIn.getBlock()) instanceof PoolBlock)) break;
                PoolBlock pb = (PoolBlock)block;
                int level = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level >= pb.faucetLevel));
                break;
            }
            case SOUTH: {
                Block level;
                if (!((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)).booleanValue() || !((level = facingStateIn.getBlock()) instanceof PoolBlock)) break;
                PoolBlock pb = (PoolBlock)level;
                int level2 = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level2 >= pb.faucetLevel));
                break;
            }
            case EAST: {
                Block level2;
                if (!((Boolean)state.getValue((Property)BlockStateProperties.EAST)).booleanValue() || !((level2 = facingStateIn.getBlock()) instanceof PoolBlock)) break;
                PoolBlock pb = (PoolBlock)level2;
                int level3 = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level3 >= pb.faucetLevel));
                break;
            }
            case WEST: {
                Block level3;
                if (!((Boolean)state.getValue((Property)BlockStateProperties.WEST)).booleanValue() || !((level3 = facingStateIn.getBlock()) instanceof PoolBlock)) break;
                PoolBlock pb = (PoolBlock)level3;
                int level4 = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level4 >= pb.faucetLevel));
                break;
            }
            case DOWN: {
                if (!((Boolean)state.getValue((Property)BlockStatePropertiesAA.ACTIVATED)).booleanValue()) break;
                state = facingStateIn.getBlock() instanceof WaterTrickleBlock ? (BlockState)state.setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(false)) : (BlockState)state.setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(true));
            }
        }
        if (worldIn.isClientSide() && ((Boolean)state.getValue((Property)BlockStatePropertiesAA.ACTIVATED)).booleanValue() && !lastActivation) {
            worldIn.playSound(null, currentPosIn, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, 0.6f);
            worldIn.playSound(null, currentPosIn, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
        if (!worldIn.isClientSide() && (Boolean)state.getValue((Property)BlockStatePropertiesAA.ACTIVATED) != lastActivation) {
            worldIn.scheduleTick(currentPosIn, (Block)this, 5);
        }
        return state;
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        if (((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.WEST)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.NORTH)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.EAST)).booleanValue()) {
            index += 8;
        }
        if (index > 14) {
            index = 0;
        }
        return index;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean s = (Boolean)state.getValue((Property)BlockStateProperties.SOUTH);
        boolean w = (Boolean)state.getValue((Property)BlockStateProperties.WEST);
        boolean n = (Boolean)state.getValue((Property)BlockStateProperties.NORTH);
        boolean e = (Boolean)state.getValue((Property)BlockStateProperties.EAST);
        if (!(s || w || n || e)) {
            return Shapes.block();
        }
        int idx = this.getShapeIndex(state, world, pos, context);
        return VoxelShapes.FAUCET_FOUR_SIDES[idx];
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.NORTH)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.EAST)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.EAST)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.NORTH)));
            }
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.NORTH)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.EAST)));
            }
        }
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.NORTH)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.EAST)));
            }
            case FRONT_BACK: {
                return state;
            }
        }
        return state;
    }
}

