/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftime.dawnoftime.block.IBlockSpecialDisplay;
import org.dawnoftime.dawnoftime.block.templates.BlockDoT;
import org.dawnoftime.dawnoftime.util.VoxelShapes;

public class FlowerPotBlockDoT
extends BlockDoT
implements IBlockSpecialDisplay {
    private Item itemInPot;

    public FlowerPotBlockDoT(@Nullable Item itemInPot) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT), VoxelShapes.FLOWER_POT_SHAPE);
        this.itemInPot = itemInPot;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player entity, BlockHitResult ray) {
        if (this.itemInPot != null && !world.isClientSide() && entity.getItemInHand(entity.getUsedItemHand()).isEmpty()) {
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)this.itemInPot));
            world.setBlock(pos, Blocks.FLOWER_POT.defaultBlockState(), 2);
        }
        return super.useWithoutItem(state, world, pos, entity, ray);
    }

    @Override
    public float getDisplayScale() {
        return 0.667f;
    }
}

