/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftime.dawnoftime.block.templates.SlabBlockDoT;
import org.jetbrains.annotations.Nullable;

public class MixedRoofSupportBlock
extends SlabBlockDoT {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    private final Supplier<Block> roofSlabBlockSupplier;

    public MixedRoofSupportBlock(Supplier<Block> roofSlabBlockSupplier, BlockBehaviour.Properties properties) {
        super(properties);
        this.roofSlabBlockSupplier = roofSlabBlockSupplier;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)SlabBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, SHAPE});
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        BlockState newState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(blockpos);
        Direction direction = context.getClickedFace();
        newState = (BlockState)newState.setValue((Property)SlabBlock.TYPE, (Comparable)(direction != Direction.DOWN && (direction == Direction.UP || context.getClickLocation().y - (double)blockpos.getY() <= 0.5) ? SlabType.BOTTOM : SlabType.TOP));
        return (BlockState)((BlockState)newState.setValue((Property)SlabBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue(SHAPE, (Comparable)this.getShapeProperty(newState, (LevelReader)context.getLevel(), pos));
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        Direction facing = hit.getDirection();
        ItemStack itemStack = player.getItemInHand(player.getUsedItemHand());
        if (!player.isCrouching() && player.mayUseItemAt(pos, facing, itemStack) && facing.getAxis().isVertical() && !itemStack.isEmpty() && facing == Direction.UP && state.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM && itemStack.getItem() == this.roofSlabBlockSupplier.get().asItem() && worldIn.setBlock(pos, (BlockState)state.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE), 11)) {
            this.setPlacedBy(worldIn, pos, state, (LivingEntity)player, itemStack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, pos, itemStack);
            }
            SoundType soundtype = this.getSoundType(state);
            worldIn.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, worldIn, pos, player, hit);
    }

    public static Item getBlockItem(MixedRoofSupportBlock block) {
        return new BlockItem((Block)block, new Item.Properties()){

            public InteractionResult place(BlockPlaceContext context) {
                Direction facing = context.getClickedFace();
                if (context.getPlayer() != null && context.getPlayer().isCrouching() || !facing.getAxis().isVertical()) {
                    return super.place(context);
                }
                Player player = context.getPlayer();
                ItemStack itemStack = context.getItemInHand();
                Level worldIn = context.getLevel();
                BlockPos pos = context.getClickedPos();
                if (!context.replacingClickedOnBlock()) {
                    pos = pos.relative(facing.getOpposite());
                }
                if (player != null && !player.mayUseItemAt(pos, facing, itemStack)) {
                    return super.place(context);
                }
                if (!itemStack.isEmpty()) {
                    BlockState state = worldIn.getBlockState(pos);
                    MixedRoofSupportBlock block = (MixedRoofSupportBlock)this.getBlock();
                    if (state.getBlock() == block.roofSlabBlockSupplier.get() && state.getValue((Property)SlabBlock.TYPE) == SlabType.TOP) {
                        BlockState madeState = block.getStateForPlacement(context);
                        if (madeState == null) {
                            return super.place(context);
                        }
                        if (worldIn.setBlock(pos, (BlockState)(madeState = (BlockState)madeState.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE), 11)) {
                            this.getBlock().setPlacedBy(worldIn, pos, state, (LivingEntity)player, itemStack);
                            if (player instanceof ServerPlayer) {
                                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, pos, itemStack);
                            }
                            SoundType soundtype = block.getSoundType(state);
                            worldIn.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                            itemStack.shrink(1);
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
                return super.place(context);
            }
        };
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing.getAxis().isHorizontal() ? (BlockState)stateIn.setValue(SHAPE, (Comparable)this.getShapeProperty(stateIn, (LevelReader)worldIn, currentPos)) : stateIn;
    }

    private StairsShape getShapeProperty(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction adjacentDirection;
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState adjacentState = worldIn.getBlockState(pos.relative(direction));
        if (this.isSameBlock(adjacentState) && state.getValue((Property)SlabBlock.TYPE) == SlabType.TOP == (adjacentState.getValue((Property)SlabBlock.TYPE) == SlabType.TOP) && (adjacentDirection = (Direction)adjacentState.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && this.isConnectableRoofSupport(state, worldIn, pos, adjacentDirection.getOpposite())) {
            return adjacentDirection == direction.getCounterClockWise() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        adjacentState = worldIn.getBlockState(pos.relative(direction.getOpposite()));
        if (this.isSameBlock(adjacentState) && state.getValue((Property)SlabBlock.TYPE) == SlabType.TOP == (adjacentState.getValue((Property)SlabBlock.TYPE) == SlabType.TOP) && (adjacentDirection = (Direction)adjacentState.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && this.isConnectableRoofSupport(state, worldIn, pos, adjacentDirection)) {
            return adjacentDirection == direction.getCounterClockWise() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private boolean isConnectableRoofSupport(BlockState state, LevelReader worldIn, BlockPos pos, Direction face) {
        BlockState adjacentState = worldIn.getBlockState(pos.relative(face));
        return !this.isSameBlock(adjacentState) || adjacentState.getValue((Property)FACING) != state.getValue((Property)FACING) || adjacentState.getValue((Property)SlabBlock.TYPE) == SlabType.TOP != (state.getValue((Property)SlabBlock.TYPE) == SlabType.TOP);
    }

    public boolean isSameBlock(BlockState state) {
        return state.getBlock() == this;
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluid) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() || fluid.getType() != Fluids.WATER) {
            return false;
        }
        if (!world.isClientSide()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            world.scheduleTick(pos, fluid.getType(), fluid.getType().getTickDelay((LevelReader)world));
        }
        return true;
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && fluid == Fluids.WATER;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.getValue(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.rotate(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.rotate(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.mirror(state, mirrorIn);
    }
}

