/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.dawnoftime.dawnoftime.block.templates.CenteredDoorBlock;
import org.jetbrains.annotations.NotNull;

public class PaneBlockDoT
extends IronBarsBlock {
    public PaneBlockDoT(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Fluid fluid = context.getLevel().getFluidState(context.getClickedPos()).getType();
        BlockPos posNorth = pos.north();
        BlockPos posSouth = pos.south();
        BlockPos posWest = pos.west();
        BlockPos posEast = pos.east();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.canAttachPane((LevelReader)world, posNorth, Direction.SOUTH, world.getBlockState(posNorth))))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.canAttachPane((LevelReader)world, posSouth, Direction.NORTH, world.getBlockState(posSouth))))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.canAttachPane((LevelReader)world, posWest, Direction.EAST, world.getBlockState(posWest))))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.canAttachPane((LevelReader)world, posEast, Direction.WEST, world.getBlockState(posEast))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.WATER));
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (adjacentBlockState.getBlock() instanceof PaneBlockDoT) {
            return false;
        }
        return super.skipRendering(state, adjacentBlockState, side);
    }

    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return facing.getAxis().isHorizontal() ? (BlockState)stateIn.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(this.canAttachPane((LevelReader)worldIn, facingPos, facing.getOpposite(), facingState))) : stateIn;
    }

    public boolean canAttachPane(LevelReader level, BlockPos pos, Direction dir, BlockState adjacentState) {
        Block block = adjacentState.getBlock();
        if (block instanceof IronBarsBlock || adjacentState.is(BlockTags.WALLS)) {
            return true;
        }
        if (block instanceof CenteredDoorBlock) {
            return ((Direction)adjacentState.getValue((Property)DoorBlock.FACING)).getAxis() != dir.getAxis();
        }
        return !PaneBlockDoT.isExceptionForConnection((BlockState)adjacentState) && adjacentState.isFaceSturdy((BlockGetter)level, pos, dir);
    }
}

