/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.general.WaterTrickleBlock;
import org.dawnoftime.dawnoftime.block.templates.BlockDoT;
import org.dawnoftime.dawnoftime.block.templates.FaucetBlock;
import org.dawnoftime.dawnoftime.mixin.impl.BucketItemAccessor;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.jetbrains.annotations.NotNull;

public class PoolBlock
extends BlockDoT {
    public final int maxLevel;
    public final int faucetLevel;

    public PoolBlock(BlockBehaviour.Properties propertiesIn, int maxLevelIn, int faucetLevelIn, VoxelShape[] shapes) {
        super(propertiesIn.lightLevel(state -> 1), shapes);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStatePropertiesAA.HAS_PILLAR, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(0)));
        this.maxLevel = maxLevelIn;
        this.faucetLevel = faucetLevelIn;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.NORTH}).add(new Property[]{BlockStateProperties.EAST}).add(new Property[]{BlockStateProperties.SOUTH}).add(new Property[]{BlockStateProperties.WEST}).add(new Property[]{BlockStatePropertiesAA.HAS_PILLAR}).add(new Property[]{BlockStatePropertiesAA.LEVEL});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        if (((Boolean)state.getValue((Property)BlockStateProperties.NORTH)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.EAST)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.WEST)).booleanValue()) {
            index += 8;
        }
        if (((Boolean)state.getValue((Property)BlockStatePropertiesAA.HAS_PILLAR)).booleanValue()) {
            index += 16;
        }
        return index;
    }

    public BlockState getStateForPlacement(BlockPlaceContext contextIn) {
        PoolLevelAndSides levelAndSides = PoolBlock.levelOfPoolAround(contextIn.getClickedPos(), (LevelAccessor)contextIn.getLevel());
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(levelAndSides.south))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(levelAndSides.north))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(levelAndSides.right))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(levelAndSides.left));
        int level = levelAndSides.level;
        if (level <= 0 && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAround(contextIn.getClickedPos(), (LevelAccessor)contextIn.getLevel()))) {
            level = 1;
            if (!contextIn.getLevel().isClientSide()) {
                contextIn.getLevel().scheduleTick(contextIn.getClickedPos(), (Block)this, 5);
            }
        }
        state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(level));
        return state;
    }

    public InteractionResult useWithoutItem(BlockState blockStateIn, Level worldIn, BlockPos blockPosIn, Player playerEntityIn, BlockHitResult blockRayTraceResultIn) {
        ItemStack itemStack = playerEntityIn.getMainHandItem();
        if (!playerEntityIn.isCrouching()) {
            int lastLevel;
            int nextLevel = lastLevel = ((Integer)blockStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL)).intValue();
            boolean tryToChangeLevel = false;
            ItemStack newItemStack = null;
            if (itemStack.getItem() instanceof BucketItem) {
                if (((BucketItemAccessor)itemStack.getItem()).getContent() instanceof WaterFluid) {
                    nextLevel = this.maxLevel;
                    if (!playerEntityIn.isCreative()) {
                        newItemStack = new ItemStack((ItemLike)Items.BUCKET);
                    }
                } else if (((BucketItemAccessor)itemStack.getItem()).getContent() instanceof EmptyFluid) {
                    nextLevel = 0;
                    if (!playerEntityIn.isCreative()) {
                        newItemStack = new ItemStack((ItemLike)Items.WATER_BUCKET);
                    }
                }
                tryToChangeLevel = true;
            } else if (itemStack.getItem() instanceof PotionItem) {
                Potion potion = Utils.getPotionByName(Utils.getItemKeyAsString(itemStack.getItem()));
                if (potion.getEffects().isEmpty() && nextLevel + 1 < this.maxLevel) {
                    ++nextLevel;
                    if (!playerEntityIn.isCreative()) {
                        newItemStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                    }
                }
                tryToChangeLevel = true;
            } else if (itemStack.getItem() instanceof BottleItem) {
                Potion potion = Utils.getPotionByName(Utils.getItemKeyAsString(itemStack.getItem()));
                if (potion.getEffects().isEmpty() && nextLevel - 1 >= 0) {
                    --nextLevel;
                    if (!playerEntityIn.isCreative()) {
                        newItemStack = Items.POTION.getDefaultInstance();
                    }
                }
                tryToChangeLevel = true;
            }
            if (tryToChangeLevel) {
                if (nextLevel == lastLevel) {
                    return InteractionResult.CONSUME;
                }
                if (newItemStack != null) {
                    itemStack.shrink(1);
                    playerEntityIn.getInventory().add(newItemStack);
                }
                blockStateIn = (BlockState)blockStateIn.setValue((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(nextLevel));
                worldIn.setBlock(blockPosIn, blockStateIn, 10);
                if (nextLevel == 0) {
                    PoolBlock.removeWaterAround(blockStateIn, blockPosIn, worldIn);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (itemStack.isEmpty()) {
            blockStateIn = (BlockState)blockStateIn.setValue((Property)BlockStatePropertiesAA.HAS_PILLAR, (Comparable)Boolean.valueOf((Boolean)blockStateIn.getValue((Property)BlockStatePropertiesAA.HAS_PILLAR) == false));
            worldIn.setBlock(blockPosIn, blockStateIn, 10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void setPlacedBy(Level worldIn, BlockPos blockPosIn, BlockState blockStateIn, LivingEntity entityIn, ItemStack itemStackIn) {
        if (entityIn instanceof Player && !entityIn.isShiftKeyDown()) {
            super.setPlacedBy(worldIn, blockPosIn, blockStateIn, entityIn, itemStackIn);
            BlockPos blockPos = blockPosIn.below();
            BlockState blockState = worldIn.getBlockState(blockPos);
            if (blockState.getBlock() == this) {
                blockState = (BlockState)blockState.setValue((Property)BlockStatePropertiesAA.HAS_PILLAR, (Comparable)Boolean.valueOf(true));
                worldIn.setBlock(blockPos, blockState, 10);
            }
        }
    }

    public void tick(BlockState blockStateIn, ServerLevel serverWorldIn, BlockPos blockPosIn, RandomSource randomIn) {
        super.tick(blockStateIn, serverWorldIn, blockPosIn, randomIn);
        boolean increase = EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAround(blockPosIn, (LevelAccessor)serverWorldIn));
        if (increase) {
            int level = (Integer)blockStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
            if (level < this.maxLevel) {
                blockStateIn = (BlockState)blockStateIn.setValue((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(level + 1));
                serverWorldIn.setBlock(blockPosIn, blockStateIn, 10);
                if (level + 1 < this.maxLevel) {
                    serverWorldIn.scheduleTick(blockPosIn, (Block)this, 5);
                }
            }
        } else {
            int level = (Integer)blockStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
            if (level - 1 >= 0) {
                blockStateIn = (BlockState)blockStateIn.setValue((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(--level));
                serverWorldIn.setBlock(blockPosIn, blockStateIn, 10);
                if (level - 1 >= 0) {
                    serverWorldIn.scheduleTick(blockPosIn, (Block)this, 5);
                }
            }
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction directionIn, BlockState facingStateIn, LevelAccessor worldIn, BlockPos currentPosIn, BlockPos facingPosIn) {
        if (directionIn.getAxis().isHorizontal()) {
            boolean hasPoolInSide;
            boolean bl = hasPoolInSide = facingStateIn.getBlock() == this;
            if (hasPoolInSide && (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL) >= 0) {
                stateIn = (BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.LEVEL, (Comparable)((Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL)));
            }
            switch (directionIn) {
                case NORTH: {
                    stateIn = (BlockState)stateIn.setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
                case EAST: {
                    stateIn = (BlockState)stateIn.setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
                case SOUTH: {
                    stateIn = (BlockState)stateIn.setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
                case WEST: {
                    stateIn = (BlockState)stateIn.setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
            }
        }
        int level = (Integer)stateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
        if (facingPosIn.getY() == currentPosIn.getY() + 1) {
            int lastLevel = level;
            EnumActivatorState state = PoolBlock.hasOnePoolActivatorAround(currentPosIn, worldIn);
            if (EnumActivatorState.ENABLED.equals((Object)state)) {
                if (level < this.maxLevel) {
                    ++level;
                }
            } else if (EnumActivatorState.DISABLED.equals((Object)state) && level - 1 >= 0) {
                --level;
            }
            stateIn = (BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(level));
            if (!worldIn.isClientSide() && lastLevel != level) {
                worldIn.scheduleTick(currentPosIn, (Block)this, 5);
            }
        }
        return stateIn;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Utils.addTooltip(tooltipComponents, "add_column");
    }

    public int getLightBlock(BlockState p_200011_1_In, BlockGetter p_200011_2_In, BlockPos p_200011_3_In) {
        return 1;
    }

    public boolean useShapeForLightOcclusion(BlockState p_220074_1_In) {
        return false;
    }

    public boolean propagatesSkylightDown(BlockState p_200123_1_In, BlockGetter p_200123_2_In, BlockPos p_200123_3_In) {
        return true;
    }

    public static boolean removeWaterAround(BlockState blockStateIn, BlockPos blockPosIn, Level worldIn) {
        return PoolBlock.removeWaterAround(new LinkedHashMap<BlockPos, BlockState>(), blockStateIn, blockPosIn, worldIn, 0.0f, 0.0f);
    }

    private static boolean removeWaterAround(Map<BlockPos, BlockState> testedPositionsIn, BlockState blockStateIn, BlockPos blockPosIn, Level worldIn, float prohibitedXIn, float prohibitedZIn) {
        boolean success = (Integer)blockStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL) > 0;
        blockStateIn = (BlockState)blockStateIn.setValue((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(0));
        worldIn.setBlock(blockPosIn, blockStateIn, 10);
        if (prohibitedXIn != 1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, 1, 0)) {
            success = true;
        }
        if (prohibitedXIn != -1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, -1, 0)) {
            success = true;
        }
        if (prohibitedZIn != 1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, 0, 1)) {
            success = true;
        }
        if (prohibitedZIn != -1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, 0, -1)) {
            success = true;
        }
        return success;
    }

    private static boolean removeWaterAroundOffset(Map<BlockPos, BlockState> testedPositionsIn, BlockPos blockPosIn, Level worldIn, int x, int z) {
        BlockPos pos = blockPosIn.offset(x, 0, z);
        if (!testedPositionsIn.containsKey(pos)) {
            BlockState state = worldIn.getBlockState(pos);
            if (state.getBlock() instanceof PoolBlock) {
                testedPositionsIn.put(pos, state);
                return PoolBlock.removeWaterAround(testedPositionsIn, state, pos, worldIn, x, z);
            }
            if (state.getBlock() instanceof FaucetBlock) {
                state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(false));
                worldIn.setBlock(pos, state, 10);
            }
        }
        return false;
    }

    public static EnumActivatorState hasOnePoolActivatorAround(BlockPos blockPosIn, LevelAccessor worldIn) {
        return PoolBlock.hasOnePoolActivatorAround(new LinkedHashMap<BlockPos, BlockState>(), blockPosIn, worldIn, 0.0f, 0.0f);
    }

    private static EnumActivatorState hasOnePoolActivatorAround(Map<BlockPos, BlockState> testedPositionsIn, BlockPos blockPosIn, LevelAccessor worldIn, float prohibitedXIn, float prohibitedZIn) {
        if (testedPositionsIn.containsKey(blockPosIn)) {
            return EnumActivatorState.NO;
        }
        BlockState state = worldIn.getBlockState(blockPosIn.above());
        testedPositionsIn.put(blockPosIn, state);
        if (state.getBlock() instanceof WaterTrickleBlock || state.getBlock() instanceof FaucetBlock && ((Boolean)state.getValue((Property)BlockStatePropertiesAA.ACTIVATED)).booleanValue()) {
            return EnumActivatorState.ENABLED;
        }
        if (prohibitedXIn != 1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, 1, 0)) || prohibitedXIn != -1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, -1, 0)) || prohibitedZIn != 1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, 0, 1)) || prohibitedZIn != -1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, 0, -1))) {
            return EnumActivatorState.ENABLED;
        }
        return EnumActivatorState.NO;
    }

    public static EnumActivatorState hasOnePoolActivatorAroundOffset(Map<BlockPos, BlockState> testedPositionsIn, LevelAccessor worldIn, BlockPos baseBlockPosIn, int xOffsetIn, int zOffsetIn) {
        BlockPos offsetBlockPos = baseBlockPosIn.offset(xOffsetIn, 0, zOffsetIn);
        BlockState offsetState = worldIn.getBlockState(offsetBlockPos);
        if (offsetState.getBlock() instanceof PoolBlock) {
            return PoolBlock.hasOnePoolActivatorAround(testedPositionsIn, offsetBlockPos, worldIn, -xOffsetIn, -zOffsetIn);
        }
        return EnumActivatorState.NO;
    }

    private static PoolLevelAndSides levelOfPoolAround(BlockPos blockPosIn, LevelAccessor worldIn) {
        return PoolBlock.levelOfPoolAround(new LinkedHashMap<BlockPos, BlockState>(), new PoolLevelAndSides(), blockPosIn, worldIn, 0.0f, 0.0f);
    }

    private static PoolLevelAndSides levelOfPoolAround(Map<BlockPos, BlockState> testedPositionsIn, PoolLevelAndSides poolLevelAndSidesIn, BlockPos blockPosIn, LevelAccessor worldIn, float prohibitedXIn, float prohibitedZIn) {
        int level;
        boolean center;
        boolean bl = center = prohibitedXIn == 0.0f && prohibitedZIn == 0.0f;
        if (prohibitedXIn != 1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, 1, 0);
            if (level > 0 && center) {
                poolLevelAndSidesIn.right = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        if (prohibitedXIn != -1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, -1, 0);
            if (level > 0 && center) {
                poolLevelAndSidesIn.left = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        if (prohibitedZIn != 1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, 0, 1);
            if (level > 0 && center) {
                poolLevelAndSidesIn.north = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        if (prohibitedZIn != -1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, 0, -1);
            if (level > 0 && center) {
                poolLevelAndSidesIn.south = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        return poolLevelAndSidesIn;
    }

    private static int poolLevelAroundOffset(Map<BlockPos, BlockState> testedPositionsIn, PoolLevelAndSides poolLevelAndSidesIn, BlockPos baseBlockPosIn, LevelAccessor worldIn, int xOffsetIn, int zOffsetIn) {
        BlockPos pos = baseBlockPosIn.offset(xOffsetIn, 0, zOffsetIn);
        if (testedPositionsIn.containsKey(pos)) {
            return -1;
        }
        BlockState state = worldIn.getBlockState(pos);
        testedPositionsIn.put(pos, state);
        if (state.getBlock() instanceof PoolBlock) {
            PoolBlock.levelOfPoolAround(testedPositionsIn, poolLevelAndSidesIn, pos, worldIn, -xOffsetIn, -zOffsetIn);
            int currentLevel = (Integer)state.getValue((Property)BlockStatePropertiesAA.LEVEL);
            return Math.max(currentLevel, poolLevelAndSidesIn.level);
        }
        return -1;
    }

    public static final class PoolLevelAndSides {
        public boolean left;
        public boolean right;
        public boolean north;
        public boolean south;
        public int level = 0;
    }

    public static enum EnumActivatorState {
        NO,
        DISABLED,
        ENABLED;

    }
}

