/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedHorizontalBlock;
import org.jetbrains.annotations.NotNull;

public class SidedWindowBlock
extends WaterloggedHorizontalBlock {
    private static final BooleanProperty UP = BlockStateProperties.UP;
    private static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;

    public SidedWindowBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{UP, ATTACHED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level worldIn = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return this.defaultBlockState();
        }
        return (BlockState)((BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(this.canConnectVertical(state, worldIn, pos)))).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(this.canConnectHorizontal(state, worldIn, pos)));
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos, isMoving);
        boolean changeTOP = this.canConnectVertical(state, worldIn, pos);
        boolean changeSIDE = this.canConnectHorizontal(state, worldIn, pos);
        BlockState newState = state;
        if (changeTOP != (Boolean)state.getValue((Property)UP)) {
            newState = (BlockState)newState.setValue((Property)UP, (Comparable)Boolean.valueOf(changeTOP));
        }
        if (changeSIDE != (Boolean)state.getValue((Property)ATTACHED)) {
            newState = (BlockState)newState.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(changeSIDE));
        }
        if (changeTOP != (Boolean)state.getValue((Property)UP) || changeSIDE != (Boolean)state.getValue((Property)ATTACHED)) {
            worldIn.setBlock(pos, newState, 10);
        }
    }

    private boolean canConnectVertical(BlockState state, Level worldIn, BlockPos pos) {
        if (this.isSameWindowAndSide(state, worldIn, pos.below())) {
            return !this.isSameWindowAndSide(state, worldIn, pos.above());
        }
        return false;
    }

    private boolean canConnectHorizontal(BlockState state, Level worldIn, BlockPos pos) {
        return this.isSameWindowAndSide(state, worldIn, pos.relative(((Direction)state.getValue((Property)FACING)).getCounterClockWise()));
    }

    private boolean isSameWindowAndSide(BlockState state, Level worldIn, BlockPos pos) {
        BlockState otherState = worldIn.getBlockState(pos);
        if (otherState.getBlock() != this) {
            return false;
        }
        return otherState.getValue((Property)FACING) == state.getValue((Property)FACING);
    }
}

