/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.IBlockPillar;
import org.dawnoftime.dawnoftime.block.templates.BeamBlock;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class SupportBeamBlock
extends WaterloggedBlock {
    private static final EnumProperty<BlockStatePropertiesAA.PillarConnection> PILLAR_CONNECTION = BlockStatePropertiesAA.PILLAR_CONNECTION;
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    private static final BooleanProperty SUBAXIS = BlockStatePropertiesAA.SUBAXIS;

    public SupportBeamBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.SUPPORT_BEAM_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).setValue((Property)SUBAXIS, (Comparable)Boolean.valueOf(false))).setValue(PILLAR_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.PillarConnection.NOTHING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PILLAR_CONNECTION, HORIZONTAL_AXIS, SUBAXIS});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index;
        switch ((BlockStatePropertiesAA.PillarConnection)((Object)state.getValue(PILLAR_CONNECTION))) {
            case FOUR_PX: {
                int n = 3;
                break;
            }
            case EIGHT_PX: {
                int n = 6;
                break;
            }
            case TEN_PX: {
                int n = 9;
                break;
            }
            default: {
                int n = index = 0;
            }
        }
        if (((Boolean)state.getValue((Property)SUBAXIS)).booleanValue()) {
            return index + 2;
        }
        return state.getValue(HORIZONTAL_AXIS) == Direction.Axis.Z ? index + 1 : index;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)super.getStateForPlacement(context).setValue(HORIZONTAL_AXIS, (Comparable)context.getHorizontalDirection().getAxis());
        return this.getCurrentState(state, (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return this.getCurrentState(stateIn, worldIn, currentPos);
    }

    private BlockState getCurrentState(BlockState stateIn, LevelAccessor worldIn, BlockPos currentPos) {
        if (stateIn.getValue(HORIZONTAL_AXIS) == Direction.Axis.X) {
            if (this.canConnect(worldIn, currentPos, Direction.NORTH) || this.canConnect(worldIn, currentPos, Direction.SOUTH)) {
                stateIn = (BlockState)stateIn.setValue((Property)SUBAXIS, (Comparable)Boolean.valueOf(true));
            }
        } else if (this.canConnect(worldIn, currentPos, Direction.EAST) || this.canConnect(worldIn, currentPos, Direction.WEST)) {
            stateIn = (BlockState)stateIn.setValue((Property)SUBAXIS, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)stateIn.setValue(PILLAR_CONNECTION, (Comparable)((Object)IBlockPillar.getPillarConnectionAbove(worldIn, currentPos.below())));
    }

    private boolean canConnect(LevelAccessor world, BlockPos pos, Direction direction) {
        BlockState state = world.getBlockState(pos.relative(direction));
        return this.isConnectibleBeam(state, direction) || this.isConnectibleSupportBeam(state, direction) || this.isConnectibleBeam(state, direction) || this.isConnectibleSupportBeam(state, direction);
    }

    private boolean isConnectibleBeam(BlockState state, Direction direction) {
        if (state.getBlock() instanceof BeamBlock) {
            return direction.getAxis() == Direction.Axis.X ? ((Boolean)state.getValue((Property)BeamBlock.AXIS_X)).booleanValue() : ((Boolean)state.getValue((Property)BeamBlock.AXIS_Z)).booleanValue();
        }
        return false;
    }

    private boolean isConnectibleSupportBeam(BlockState state, Direction direction) {
        if (state.getBlock() instanceof SupportBeamBlock) {
            return state.getValue(HORIZONTAL_AXIS) == direction.getAxis();
        }
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) {
            return (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)(state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return super.rotate(state, rot);
    }
}

