/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.IBlockPillar;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class SupportSlabBlock
extends WaterloggedBlock {
    private static final EnumProperty<BlockStatePropertiesAA.PillarConnection> PILLAR_CONNECTION = BlockStatePropertiesAA.PILLAR_CONNECTION;

    public SupportSlabBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.SUPPORT_SLAB_SHAPES);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(PILLAR_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.PillarConnection.NOTHING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PILLAR_CONNECTION});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((BlockStatePropertiesAA.PillarConnection)((Object)state.getValue(PILLAR_CONNECTION))) {
            case BlockStatePropertiesAA.PillarConnection.FOUR_PX -> 1;
            case BlockStatePropertiesAA.PillarConnection.EIGHT_PX -> 2;
            case BlockStatePropertiesAA.PillarConnection.TEN_PX -> 3;
            default -> 0;
        };
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(PILLAR_CONNECTION, (Comparable)((Object)IBlockPillar.getPillarConnectionAbove((LevelAccessor)context.getLevel(), context.getClickedPos().below())));
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing == Direction.DOWN ? (BlockState)stateIn.setValue(PILLAR_CONNECTION, (Comparable)((Object)IBlockPillar.getPillarConnectionAbove(worldIn, currentPos.below()))) : stateIn;
    }
}

