/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.BlockDoT;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.dawnoftime.dawnoftime.util.VoxelShapesBuilder;

public class WaterJetBlock
extends BlockDoT {
    public WaterJetBlock(BlockBehaviour.Properties propertiesIn) {
        super(propertiesIn);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(false))).setValue(BlockStatePropertiesAA.NORTH_STATE, (Comparable)((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE))).setValue(BlockStatePropertiesAA.SOUTH_STATE, (Comparable)((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE))).setValue(BlockStatePropertiesAA.EAST_STATE, (Comparable)((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE))).setValue(BlockStatePropertiesAA.WEST_STATE, (Comparable)((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE))).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        super.createBlockStateDefinition(b);
        b.add(new Property[]{BlockStateProperties.UP, BlockStateProperties.DOWN, BlockStatePropertiesAA.NORTH_STATE, BlockStatePropertiesAA.SOUTH_STATE, BlockStatePropertiesAA.EAST_STATE, BlockStatePropertiesAA.WEST_STATE, BlockStateProperties.POWERED, BlockStatePropertiesAA.ACTIVATED});
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        if (ctx.isSecondaryUseActive()) {
            return false;
        }
        return ctx.getItemInHand().is(this.asItem());
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        BlockState existing = ctx.getLevel().getBlockState(pos);
        boolean same = existing.getBlock() == this;
        BlockState base = same ? existing : this.defaultBlockState();
        BlockStatePropertiesAA.VerticalLimitedConnection vertical = WaterJetBlock.resolveVerticalConnection(ctx.getClickLocation(), pos);
        return WaterJetBlock.addConnection(base, ctx.getClickedFace(), vertical);
    }

    private static BlockStatePropertiesAA.VerticalLimitedConnection resolveVerticalConnection(Vec3 hitLocation, BlockPos blockPos) {
        double localY = hitLocation.y - (double)blockPos.getY();
        return localY <= 0.5 ? BlockStatePropertiesAA.VerticalLimitedConnection.BOTTOM : BlockStatePropertiesAA.VerticalLimitedConnection.TOP;
    }

    private static BlockState addConnection(BlockState state, Direction face, BlockStatePropertiesAA.VerticalLimitedConnection vertical) {
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> (BlockState)state.setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(true));
            case Direction.UP -> (BlockState)state.setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(true));
            case Direction.SOUTH -> (BlockState)state.setValue(BlockStatePropertiesAA.NORTH_STATE, (Comparable)((Object)vertical));
            case Direction.NORTH -> (BlockState)state.setValue(BlockStatePropertiesAA.SOUTH_STATE, (Comparable)((Object)vertical));
            case Direction.WEST -> (BlockState)state.setValue(BlockStatePropertiesAA.EAST_STATE, (Comparable)((Object)vertical));
            case Direction.EAST -> (BlockState)state.setValue(BlockStatePropertiesAA.WEST_STATE, (Comparable)((Object)vertical));
        };
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            world.playSound(player, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, 0.6f);
            world.playSound(player, pos, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
        boolean activated = (Boolean)state.getValue((Property)BlockStatePropertiesAA.ACTIVATED) == false;
        state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(activated));
        world.setBlock(pos, state, 10);
        return InteractionResult.SUCCESS;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int idx = VoxelShapesBuilder.encodeWaterJetIndex((Boolean)state.getValue((Property)BlockStateProperties.UP), (Boolean)state.getValue((Property)BlockStateProperties.DOWN), (BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.SOUTH_STATE)), (BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.WEST_STATE)), (BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.NORTH_STATE)), (BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.EAST_STATE)));
        return VoxelShapes.WATERJET_SHAPES[idx];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        BlockStatePropertiesAA.VerticalLimitedConnection n = (BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.NORTH_STATE));
        BlockStatePropertiesAA.VerticalLimitedConnection e = (BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.EAST_STATE));
        BlockStatePropertiesAA.VerticalLimitedConnection s = (BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.SOUTH_STATE));
        BlockStatePropertiesAA.VerticalLimitedConnection w = (BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.WEST_STATE));
        return switch (rot) {
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(BlockStatePropertiesAA.NORTH_STATE, (Comparable)((Object)w))).setValue(BlockStatePropertiesAA.EAST_STATE, (Comparable)((Object)n))).setValue(BlockStatePropertiesAA.SOUTH_STATE, (Comparable)((Object)e))).setValue(BlockStatePropertiesAA.WEST_STATE, (Comparable)((Object)s));
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(BlockStatePropertiesAA.NORTH_STATE, (Comparable)((Object)s))).setValue(BlockStatePropertiesAA.EAST_STATE, (Comparable)((Object)w))).setValue(BlockStatePropertiesAA.SOUTH_STATE, (Comparable)((Object)n))).setValue(BlockStatePropertiesAA.WEST_STATE, (Comparable)((Object)e));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(BlockStatePropertiesAA.NORTH_STATE, (Comparable)((Object)e))).setValue(BlockStatePropertiesAA.EAST_STATE, (Comparable)((Object)s))).setValue(BlockStatePropertiesAA.SOUTH_STATE, (Comparable)((Object)w))).setValue(BlockStatePropertiesAA.WEST_STATE, (Comparable)((Object)n));
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue(BlockStatePropertiesAA.NORTH_STATE, (Comparable)((Object)((BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.SOUTH_STATE)))))).setValue(BlockStatePropertiesAA.SOUTH_STATE, (Comparable)((Object)((BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.NORTH_STATE)))));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue(BlockStatePropertiesAA.EAST_STATE, (Comparable)((Object)((BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.WEST_STATE)))))).setValue(BlockStatePropertiesAA.WEST_STATE, (Comparable)((Object)((BlockStatePropertiesAA.VerticalLimitedConnection)((Object)state.getValue(BlockStatePropertiesAA.EAST_STATE)))));
            default -> state;
        };
    }
}

