/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.blockentity;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.dawnoftime.dawnoftime.block.IBlockSpecialDisplay;
import org.dawnoftime.dawnoftime.registry.DoTBBlockEntitiesRegistry;
import org.jetbrains.annotations.NotNull;

public class DisplayerBlockEntity
extends BlockEntity
implements Container {
    private static final int SIZE = 9;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);

    public DisplayerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(DoTBBlockEntitiesRegistry.INSTANCE.DISPLAYER.get(), pPos, pBlockState);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        return tag;
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    public int getContainerSize() {
        return 9;
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    @NotNull
    public ItemStack getItem(int slot) {
        if (slot >= 9) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
        if (!itemstack.isEmpty()) {
            this.setChanged();
            this.synchroniseWithClient();
        }
        return itemstack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        int quantity = stack.getCount();
        this.items.set(slot, (Object)new ItemStack((ItemLike)stack.getItem(), 1));
        if (quantity > 0) {
            stack.setCount(quantity - 1);
        }
        this.setChanged();
        this.synchroniseWithClient();
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
        this.synchroniseWithClient();
    }

    public List<ItemStack> removeAllItems() {
        List<ItemStack> list = this.items.stream().filter(stack -> !stack.isEmpty()).collect(Collectors.toList());
        this.clearContent();
        return list;
    }

    private void synchroniseWithClient() {
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isLit() {
        if (this.getLevel() == null) {
            return false;
        }
        for (int slot = 0; slot < 9; ++slot) {
            BlockState defaultState;
            IBlockSpecialDisplay displayItem;
            BlockItem blockItem;
            Block block;
            Item item;
            ItemStack itemstack = this.getItem(slot);
            if (itemstack.isEmpty() || !((item = itemstack.getItem()) instanceof BlockItem) || !((block = (blockItem = (BlockItem)item).getBlock()) instanceof IBlockSpecialDisplay ? (displayItem = (IBlockSpecialDisplay)block).emitsLight() : (defaultState = block.defaultBlockState()).getLightEmission() > 1)) continue;
            return true;
        }
        return false;
    }
}

