/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.dawnoftime.dawnoftime.mixin.impl.client.AbstractButtonAccessor;

public class GroupButton
extends Button {
    private final ResourceLocation iconResource;
    private final int iconU;
    private final int iconV;

    public GroupButton(int x, int y, Component message, Button.OnPress pressable, ResourceLocation iconResource, int iconU, int iconV) {
        super(x, y, 20, 20, message, pressable, DEFAULT_NARRATION);
        this.iconResource = iconResource;
        this.iconU = iconU;
        this.iconV = iconV;
    }

    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (!this.visible) {
            return;
        }
        this.isHovered = pMouseX >= this.getX() && pMouseY >= this.getY() && pMouseX < this.getX() + this.width && pMouseY < this.getY() + this.height;
        int offset = this.getTextureY();
        PoseStack ps = pGuiGraphics.pose();
        ps.pushPose();
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        pGuiGraphics.blitSprite(((AbstractButtonAccessor)((Object)this)).getSprites().get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        pGuiGraphics.blitSprite(((AbstractButtonAccessor)((Object)this)).getSprites().get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        RenderSystem.disableBlend();
        ps.popPose();
        ps.pushPose();
        if (!this.active) {
            pGuiGraphics.setColor(0.5f, 0.5f, 0.5f, 1.0f);
        }
        RenderSystem.enableBlend();
        pGuiGraphics.blit(this.iconResource, this.getX() + 2, this.getY() + 2, this.iconU, this.iconV, 16, 16);
        RenderSystem.disableBlend();
        pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        ps.popPose();
    }

    private int getTextureY() {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (this.isHoveredOrFocused()) {
            i = 2;
        }
        return i;
    }
}

