/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaylistButton
extends Button {
    private final ResourceLocation buttonTexture = ResourceLocation.fromNamespaceAndPath((String)"dawnoftimebuilder", (String)"textures/gui/social_icons.png");

    public PlaylistButton(int x, int y, Button.OnPress pressable) {
        super(x, y, 12, 12, (Component)Component.empty(), pressable, DEFAULT_NARRATION);
    }

    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack ps = pGuiGraphics.pose();
        if (this.isHovered() && this.active) {
            pGuiGraphics.setColor(0.7f, 0.7f, 0.7f, 1.0f);
        }
        ps.pushPose();
        RenderSystem.enableBlend();
        pGuiGraphics.blit(this.buttonTexture, this.getX() - 1, this.getY(), 28, this.active ? 0 : 12, 12, 12);
        RenderSystem.disableBlend();
        ps.popPose();
        pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Nullable
    public Tooltip getTooltip() {
        return this.active ? super.getTooltip() : null;
    }
}

