/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.dawnoftime.dawnoftime.util.CustomWidgetTooltipHolder;
import org.jetbrains.annotations.NotNull;

public class SocialsButton
extends Button {
    private final ResourceLocation buttonIcons;
    private final ResourceLocation socialIcons;

    public SocialsButton(int x, int y, String buttonName, Button.OnPress pressable) {
        super(x, y, 28, 28, (Component)Component.empty(), pressable, DEFAULT_NARRATION);
        this.buttonIcons = ResourceLocation.fromNamespaceAndPath((String)"dawnoftimebuilder", (String)("textures/gui/social_" + buttonName + ".png"));
        this.socialIcons = ResourceLocation.fromNamespaceAndPath((String)"dawnoftimebuilder", (String)"textures/gui/social_icons.png");
        this.tooltip = new CustomWidgetTooltipHolder();
    }

    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.active) {
            PoseStack ps = pGuiGraphics.pose();
            if (this.isHovered()) {
                pGuiGraphics.setColor(0.7f, 0.7f, 0.7f, 1.0f);
            }
            ps.pushPose();
            RenderSystem.enableBlend();
            pGuiGraphics.blit(this.socialIcons, this.getX() - 1, this.getY(), 0, 0, 28, 28);
            RenderSystem.disableBlend();
            ps.popPose();
            ps.pushPose();
            RenderSystem.enableBlend();
            pGuiGraphics.blit(this.buttonIcons, this.getX() + 3, this.getY() + 4, 0, 0.0f, 0.0f, 20, 20, 20, 20);
            RenderSystem.disableBlend();
            ps.popPose();
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

