/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.dawnoftime.dawnoftime.block.IBlockSpecialDisplay;
import org.dawnoftime.dawnoftime.block.templates.DisplayerBlock;
import org.dawnoftime.dawnoftime.blockentity.DisplayerBlockEntity;
import org.jetbrains.annotations.NotNull;

public class DisplayerBERenderer
implements BlockEntityRenderer<DisplayerBlockEntity> {
    public DisplayerBERenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(DisplayerBlockEntity blockEntity, float pPartialTick, @NotNull PoseStack stack, @NotNull MultiBufferSource buffer, int light, int overlay) {
        BlockState state = blockEntity.getBlockState();
        Level level = blockEntity.getLevel();
        DisplayerBlock block = (DisplayerBlock)state.getBlock();
        double xStart = block.getDisplayerX(state);
        double yStart = block.getDisplayerY(state);
        double zStart = block.getDisplayerZ(state);
        int j = (int)blockEntity.getBlockPos().asLong();
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack = blockEntity.getItem(i);
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            if (itemStack.isEmpty()) continue;
            stack.pushPose();
            stack.translate(xStart, yStart, zStart);
            stack.translate((0.5 - xStart) * (double)(i % 3), 0.015, (0.5 - zStart) * Math.floor((double)i / 3.0));
            float rotationAngle = i == 0 || i == 8 ? 20.0f : (i == 2 || i == 6 ? -20.0f : 0.0f);
            Item item = itemStack.getItem();
            if (item instanceof BlockItem) {
                stack.mulPose(Axis.YP.rotationDegrees(rotationAngle));
                Block blockFromItem = ((BlockItem)item).getBlock();
                if (blockFromItem instanceof IBlockSpecialDisplay) {
                    float scale = ((IBlockSpecialDisplay)blockFromItem).getDisplayScale();
                    stack.scale(scale, scale, scale);
                    stack.translate(0.0f, 0.485f, 0.0f);
                } else {
                    stack.scale(0.2f, 0.2f, 0.2f);
                    stack.translate(0.0f, 0.45f, 0.0f);
                }
                itemRenderer.renderStatic(itemStack, ItemDisplayContext.NONE, light, overlay, stack, buffer, level, i + j);
            } else {
                stack.scale(0.3f, 0.3f, 0.3f);
                stack.mulPose(Axis.YP.rotationDegrees(rotationAngle + 90.0f));
                stack.mulPose(Axis.XN.rotationDegrees(90.0f));
                itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, light, overlay, stack, buffer, level, i + j);
            }
            stack.popPose();
        }
    }
}

