/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.dawnoftime.dawnoftime.registry.DoTBEntitiesRegistry;
import org.jetbrains.annotations.NotNull;

public class ChairEntity
extends Entity {
    private BlockPos pos;

    public ChairEntity(Level level) {
        super(DoTBEntitiesRegistry.INSTANCE.CHAIR_ENTITY.get(), level);
        this.noPhysics = true;
    }

    private ChairEntity(Level level, BlockPos pos, Direction direction, float pixelsXOffset, float pixelsYOffset, float pixelsZOffset) {
        this(level);
        this.pos = pos;
        this.setYRot(direction.toYRot());
        this.setPos((double)pos.getX() + (double)pixelsXOffset / 16.0, (double)pos.getY() + ((double)pixelsYOffset - 3.0) / 16.0, (double)pos.getZ() + (double)pixelsZOffset / 16.0);
    }

    public static InteractionResult createEntity(Level level, BlockPos pos, Player player, Direction direction, float pixelsXOffset, float pixelsYOffset, float pixelsZOffset) {
        if (!level.isClientSide()) {
            List seats = level.getEntitiesOfClass(ChairEntity.class, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 1.0, (double)pos.getZ() + 1.0));
            if (seats.isEmpty()) {
                ChairEntity seat = new ChairEntity(level, pos, direction, pixelsXOffset, pixelsYOffset, pixelsZOffset);
                level.addFreshEntity((Entity)seat);
                if (player.startRiding((Entity)seat, false)) {
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult createEntity(Level level, BlockPos pos, Player player, Direction direction, float pixelsYOffset) {
        return ChairEntity.createEntity(level, pos, player, direction, 8.0f, pixelsYOffset, 8.0f);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.pos == null) {
            this.pos = this.blockPosition();
        }
        if (!this.level().isClientSide() && (this.getPassengers().isEmpty() || this.level().isEmptyBlock(this.pos))) {
            this.remove(Entity.RemovalReason.KILLED);
            this.level().updateNeighbourForOutputSignal(this.blockPosition(), this.level().getBlockState(this.blockPosition()).getBlock());
        }
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag p_70037_1_) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag p_213281_1_) {
    }

    protected void clampRotation(Entity player) {
        player.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(player.getYRot() - this.getYRot()));
        float f1 = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        player.yRotO += f1 - f;
        player.setYRot(player.getYRot() + f1 - f);
        player.setYHeadRot(player.getYRot());
    }

    public void onPassengerTurned(Entity pEntityToUpdate) {
        this.clampRotation(pEntityToUpdate);
    }

    protected boolean canRide(Entity entity) {
        return true;
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity passenger) {
        Direction dir = this.getDirection();
        Direction dirCW = dir.getClockWise();
        Direction dirCCW = dir.getCounterClockWise();
        int[][] candidatePositions = new int[][]{{dir.getStepX(), dir.getStepZ()}, {dirCW.getStepX(), dirCW.getStepZ()}, {dirCCW.getStepX(), dirCCW.getStepZ()}};
        BlockPos pos = this.blockPosition();
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (Pose pose : passenger.getDismountPoses()) {
            AABB aabb = passenger.getLocalBoundsForPose(pose);
            for (int[] candidatePos : candidatePositions) {
                posMutable.set(pos.getX() + candidatePos[0], pos.getY(), pos.getZ() + candidatePos[1]);
                double posY = this.level().getBlockFloorHeight((BlockPos)posMutable);
                if (!DismountHelper.isBlockFloorValid((double)posY)) continue;
                Vec3 vec3 = Vec3.upFromBottomCenterOf((Vec3i)posMutable, (double)posY);
                if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)aabb.move(vec3))) continue;
                passenger.setPose(pose);
                return vec3;
            }
        }
        return new Vec3(this.getX(), this.getY() + 1.0, this.getZ());
    }
}

