/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.general;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IronColumnBlock
extends ConnectedVerticalBlock {
    public IronColumnBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.IRON_COLUMN_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStatePropertiesAA.SMALL_TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStatePropertiesAA.AXIS_Y, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStatePropertiesAA.AXIS_X, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStatePropertiesAA.AXIS_Z, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStatePropertiesAA.SMALL_TOP, BlockStatePropertiesAA.AXIS_X, BlockStatePropertiesAA.AXIS_Y, BlockStatePropertiesAA.AXIS_Z});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int i;
        if (!((Boolean)state.getValue((Property)BlockStatePropertiesAA.AXIS_Y)).booleanValue()) {
            return ((Boolean)state.getValue((Property)BlockStatePropertiesAA.AXIS_Z)).booleanValue() ? (((Boolean)state.getValue((Property)BlockStatePropertiesAA.AXIS_X)).booleanValue() ? 2 : 1) : 0;
        }
        switch ((BlockStatePropertiesAA.VerticalConnection)((Object)state.getValue(ConnectedVerticalBlock.VERTICAL_CONNECTION))) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                int n;
                if (((Boolean)state.getValue((Property)BlockStatePropertiesAA.SMALL_TOP)).booleanValue()) {
                    n = 3;
                    break;
                }
                n = 4;
                break;
            }
            case UNDER: {
                int n;
                if (((Boolean)state.getValue((Property)BlockStatePropertiesAA.SMALL_TOP)).booleanValue()) {
                    n = 5;
                    break;
                }
                n = 6;
                break;
            }
            case ABOVE: {
                int n = 7;
                break;
            }
            case BOTH: {
                int n = i = 8;
            }
        }
        if (((Boolean)state.getValue((Property)BlockStatePropertiesAA.AXIS_X)).booleanValue()) {
            i += 6;
        }
        if (((Boolean)state.getValue((Property)BlockStatePropertiesAA.AXIS_Z)).booleanValue()) {
            i += 12;
        }
        return i;
    }

    public boolean canBeReplaced(@NotNull BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        if (useContext.getPlayer() != null && useContext.getPlayer().isCrouching()) {
            return false;
        }
        if (itemstack.getItem() == this.asItem() && useContext.replacingClickedOnBlock()) {
            return switch (useContext.getClickedFace().getAxis()) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> {
                    if (!((Boolean)state.getValue((Property)BlockStatePropertiesAA.AXIS_X)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (!((Boolean)state.getValue((Property)BlockStatePropertiesAA.AXIS_Y)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> (Boolean)state.getValue((Property)BlockStatePropertiesAA.AXIS_Z) == false;
            };
        }
        return false;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockPos abovePos = pos.above();
        BlockState state = context.getLevel().getBlockState(pos);
        if (state.getBlock() != this) {
            state = super.getStateForPlacement(context);
        }
        if (state != null) {
            switch (context.getClickedFace().getAxis()) {
                case X: {
                    return (BlockState)state.setValue((Property)BlockStatePropertiesAA.AXIS_X, (Comparable)Boolean.valueOf(true));
                }
                case Y: {
                    BlockState aboveState = level.getBlockState(abovePos);
                    state = (BlockState)((BlockState)state.setValue((Property)BlockStatePropertiesAA.AXIS_Y, (Comparable)Boolean.valueOf(true))).setValue(ConnectedVerticalBlock.VERTICAL_CONNECTION, (Comparable)((Object)this.getColumnState((LevelAccessor)level, pos, state)));
                    if (aboveState.is((Block)this)) break;
                    VoxelShape aboveShape = aboveState.getShape((BlockGetter)level, abovePos, CollisionContext.empty());
                    state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.SMALL_TOP, (Comparable)Boolean.valueOf(Utils.isShapeIncludedInShape(aboveShape, VoxelShapes.SHAPE_DOWN_16x16, VoxelShapes.SHAPE_DOWN_4x4)));
                    break;
                }
                case Z: {
                    return (BlockState)state.setValue((Property)BlockStatePropertiesAA.AXIS_Z, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        return state;
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!worldIn.isClientSide() && facing == Direction.UP && ((Boolean)stateIn.getValue((Property)BlockStatePropertiesAA.AXIS_Y)).booleanValue()) {
            if (!facingState.is((Block)this)) {
                VoxelShape aboveShape = facingState.getShape((BlockGetter)worldIn, facingPos, CollisionContext.empty());
                return (BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.SMALL_TOP, (Comparable)Boolean.valueOf(Utils.isShapeIncludedInShape(aboveShape, VoxelShapes.SHAPE_DOWN_16x16, VoxelShapes.SHAPE_DOWN_4x4)));
            }
            return (BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.SMALL_TOP, (Comparable)Boolean.valueOf(true));
        }
        return stateIn;
    }

    @Override
    public boolean isConnectible(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, Direction faceToConnect) {
        BlockState adjState = worldIn.getBlockState(pos);
        return adjState.getBlock() == this && (Boolean)adjState.getValue((Property)BlockStatePropertiesAA.AXIS_Y) != false;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
    }

    @Override
    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        return InteractionResult.PASS;
    }
}

