/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.japanese;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftime.dawnoftime.block.japanese.SmallTatamiMatBlock;
import org.dawnoftime.dawnoftime.block.templates.BlockDoT;
import org.dawnoftime.dawnoftime.registry.DoTBBlocksRegistry;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmallTatamiFloorBlock
extends BlockDoT {
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public SmallTatamiFloorBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.SMALL_TATAMI_FLOOR_SHAPES);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HORIZONTAL_AXIS});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contextIn) {
        BlockPos pos;
        Level level = contextIn.getLevel();
        BlockState currentState = level.getBlockState(pos = contextIn.getClickedPos());
        return currentState.is((Block)this) ? currentState : this.defaultBlockState();
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.isCrouching() && worldIn.isEmptyBlock(pos.above())) {
            worldIn.setBlock(pos.above(), (BlockState)((BlockState)DoTBBlocksRegistry.INSTANCE.SMALL_TATAMI_MAT.get().defaultBlockState().setValue((Property)SmallTatamiMatBlock.ROLLED, (Comparable)Boolean.valueOf(true))).setValue(SmallTatamiMatBlock.HORIZONTAL_AXIS, (Comparable)((Direction.Axis)state.getValue(HORIZONTAL_AXIS))), 10);
            worldIn.setBlock(pos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 10);
            worldIn.playSound(player, pos.above(), this.soundType.getPlaceSound(), SoundSource.BLOCKS, (this.soundType.getVolume() + 1.0f) / 2.0f, this.soundType.getPitch() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)(state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirrorIn) {
        return switch (mirrorIn) {
            case Mirror.LEFT_RIGHT -> (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)(state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
            case Mirror.FRONT_BACK -> (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)(state.getValue(HORIZONTAL_AXIS) == Direction.Axis.Z ? Direction.Axis.X : Direction.Axis.Z));
            default -> state;
        };
    }

    public void onRemove(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        world.setBlock(pos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 10);
        Containers.dropItemStack((Level)world, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)DoTBBlocksRegistry.INSTANCE.SMALL_TATAMI_MAT.get().asItem(), 1));
    }
}

