/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.japanese;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.IBlockChain;
import org.dawnoftime.dawnoftime.block.japanese.SmallTatamiFloorBlock;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.registry.DoTBBlocksRegistry;
import org.dawnoftime.dawnoftime.registry.DoTBTags;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class SmallTatamiMatBlock
extends WaterloggedBlock
implements IBlockChain {
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    public static final BooleanProperty ROLLED = BlockStatePropertiesAA.ROLLED;
    public static final IntegerProperty STACK = BlockStatePropertiesAA.STACK;

    public SmallTatamiMatBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.SMALL_TATAMI_MAT_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROLLED, (Comparable)Boolean.valueOf(false))).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)STACK, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ATTACHED, HORIZONTAL_AXIS, ROLLED, STACK});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.getValue((Property)ATTACHED)).booleanValue()) {
            return 7;
        }
        if (((Boolean)state.getValue((Property)ROLLED)).booleanValue()) {
            boolean isAxisX = state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X;
            return switch ((Integer)state.getValue((Property)STACK)) {
                default -> {
                    if (isAxisX) {
                        yield 1;
                    }
                    yield 4;
                }
                case 2 -> {
                    if (isAxisX) {
                        yield 2;
                    }
                    yield 5;
                }
                case 3 -> isAxisX ? 3 : 6;
            };
        }
        return 0;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.getLevel();
        BlockState oldState = world.getBlockState(pos = context.getClickedPos());
        if (oldState.getBlock() == this) {
            int stack = (Integer)oldState.getValue((Property)STACK);
            if (((Boolean)oldState.getValue((Property)ROLLED)).booleanValue() && !((Boolean)oldState.getValue((Property)ATTACHED)).booleanValue() && stack < 3) {
                return (BlockState)oldState.setValue((Property)STACK, (Comparable)Integer.valueOf(stack + 1));
            }
        }
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)ROLLED, (Comparable)Boolean.valueOf(world.getBlockState(pos.below()).is(DoTBTags.INSTANCE.COVERED_BLOCKS)))).setValue(HORIZONTAL_AXIS, (Comparable)context.getHorizontalDirection().getAxis());
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (((Boolean)state.getValue((Property)ATTACHED)).booleanValue()) {
            BlockState stateUp = worldIn.getBlockState(pos.above());
            Block blockUp = stateUp.getBlock();
            if (stateUp.is(BlockTags.FENCES) || worldIn.getBlockState(pos.below()).is(BlockTags.FENCES)) {
                return true;
            }
            if (IBlockChain.canBeChained(stateUp, true)) {
                return true;
            }
        }
        return !worldIn.isEmptyBlock(pos.below());
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (facing.getAxis().isVertical()) {
            BlockState stateUp;
            if (((Boolean)(stateIn = (BlockState)stateIn.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).getValue((Property)ROLLED)).booleanValue() && (Integer)stateIn.getValue((Property)STACK) == 1 && ((stateUp = worldIn.getBlockState(currentPos.above())).is(BlockTags.FENCES) || worldIn.getBlockState(currentPos.below()).is(BlockTags.FENCES) || IBlockChain.canBeChained(stateUp, true))) {
                stateIn = (BlockState)stateIn.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(true));
            }
            if (!stateIn.canSurvive((LevelReader)worldIn, currentPos)) {
                return Blocks.AIR.defaultBlockState();
            }
        }
        return stateIn;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockState newState = this.tryMergingWithSprucePlanks(state, (LevelAccessor)worldIn, pos);
        if (newState.getBlock() == Blocks.AIR) {
            worldIn.setBlock(pos, newState, 10);
        }
    }

    private BlockState tryMergingWithSprucePlanks(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        if (((Boolean)state.getValue((Property)ROLLED)).booleanValue()) {
            return state;
        }
        Block blockDown = worldIn.getBlockState(pos.below()).getBlock();
        if (blockDown == Blocks.SPRUCE_PLANKS) {
            Direction.Axis axis = (Direction.Axis)state.getValue(HORIZONTAL_AXIS);
            BlockState floorState = (BlockState)DoTBBlocksRegistry.INSTANCE.SMALL_TATAMI_FLOOR.get().defaultBlockState().setValue(SmallTatamiFloorBlock.HORIZONTAL_AXIS, (Comparable)axis);
            worldIn.setBlock(pos.below(), floorState, 10);
            return Blocks.AIR.defaultBlockState();
        }
        return (BlockState)state.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.isCrouching()) {
            int stack = (Integer)state.getValue((Property)STACK);
            boolean isRolled = (Boolean)state.getValue((Property)ROLLED);
            if (isRolled && stack == 1 && worldIn.getBlockState(pos.below()).is(DoTBTags.INSTANCE.COVERED_BLOCKS)) {
                return InteractionResult.PASS;
            }
            if ((Integer)state.getValue((Property)STACK) > 1) {
                state = (BlockState)state.setValue((Property)STACK, (Comparable)Integer.valueOf(stack - 1));
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)this.asItem()));
            } else {
                state = (BlockState)state.setValue((Property)ROLLED, (Comparable)Boolean.valueOf(!isRolled));
            }
            state = this.updateShape(state, Direction.DOWN, worldIn.getBlockState(pos.below()), (LevelAccessor)worldIn, pos, pos.below());
            worldIn.setBlock(pos, state, 10);
            worldIn.playSound(player, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS, (this.soundType.getVolume() + 1.0f) / 2.0f, this.soundType.getPitch() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        if (itemstack.getItem() == this.asItem()) {
            if (!((Boolean)state.getValue((Property)ROLLED)).booleanValue() || ((Boolean)state.getValue((Property)ATTACHED)).booleanValue() || (Integer)state.getValue((Property)STACK) == 3) {
                return false;
            }
            return useContext.replacingClickedOnBlock();
        }
        return false;
    }

    @Override
    public boolean canConnectToChainAbove(BlockState state) {
        return (Boolean)state.getValue((Property)ATTACHED);
    }

    @Override
    public boolean canConnectToChainUnder(BlockState state) {
        return (Boolean)state.getValue((Property)ATTACHED);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)(state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, this, new String[0]);
    }
}

