/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.japanese;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.japanese.TatamiFloorBlock;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.registry.DoTBBlocksRegistry;
import org.dawnoftime.dawnoftime.registry.DoTBTags;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class TatamiMatBlock
extends WaterloggedBlock {
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty ROLLED = BlockStatePropertiesAA.ROLLED;
    public static final IntegerProperty STACK = BlockStatePropertiesAA.STACK;

    public TatamiMatBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.DESTROY), VoxelShapes.TATAMI_MAT_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROLLED, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)Half.TOP)).setValue((Property)STACK, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, HALF, ROLLED, STACK});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.getValue((Property)ROLLED) != false ? (Integer)state.getValue((Property)STACK) - 1 + ((Direction)state.getValue((Property)FACING)).get2DDataValue() * 3 : 12;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction;
        BlockPos pos;
        Level world = context.getLevel();
        BlockState oldState = world.getBlockState(pos = context.getClickedPos());
        if (oldState.getBlock() == this) {
            int stack = (Integer)oldState.getValue((Property)STACK);
            if (((Boolean)oldState.getValue((Property)ROLLED)).booleanValue() && stack < 3) {
                return (BlockState)oldState.setValue((Property)STACK, (Comparable)Integer.valueOf(stack + 1));
            }
        }
        if (world.getBlockState(pos.relative(direction = context.getHorizontalDirection())).canBeReplaced(context)) {
            return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)ROLLED, (Comparable)Boolean.valueOf(world.getBlockState(pos.below()).is(DoTBTags.INSTANCE.COVERED_BLOCKS) || world.getBlockState(pos.below().relative(direction)).is(DoTBTags.INSTANCE.COVERED_BLOCKS)))).setValue((Property)FACING, (Comparable)direction);
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.getValue(HALF) == Half.BOTTOM) {
            BlockState topState = worldIn.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
            if (topState.getBlock() == this && topState.getValue(HALF) == Half.TOP && topState.getValue((Property)FACING) == state.getValue((Property)FACING)) {
                return !worldIn.isEmptyBlock(pos.below());
            }
        } else {
            return !worldIn.isEmptyBlock(pos.below());
        }
        return false;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockState newState = this.tryMergingWithSprucePlanks(state, (LevelAccessor)worldIn, pos);
        if (newState.getBlock() == Blocks.AIR) {
            worldIn.setBlock(pos, newState, 10);
        } else if (!((Boolean)newState.getValue((Property)ROLLED)).booleanValue()) {
            worldIn.setBlock(pos.relative((Direction)newState.getValue((Property)FACING)), (BlockState)newState.setValue(HALF, (Comparable)Half.BOTTOM), 3);
        }
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (facing.getAxis().isVertical()) {
            return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : this.tryMergingWithSprucePlanks(stateIn, worldIn, currentPos);
        }
        boolean mustDisappear = false;
        if (((Boolean)stateIn.getValue((Property)ROLLED)).booleanValue()) {
            return stateIn;
        }
        Direction direction = (Direction)stateIn.getValue((Property)FACING);
        if (stateIn.getValue(HALF) == Half.TOP) {
            if (direction == facing) {
                if (facingState.getBlock() == this) {
                    if (facingState.getValue((Property)FACING) != facing || facingState.getValue(HALF) != Half.BOTTOM || ((Boolean)facingState.getValue((Property)ROLLED)).booleanValue()) {
                        mustDisappear = true;
                    }
                } else {
                    mustDisappear = true;
                }
            }
        } else if (direction == facing.getOpposite()) {
            if (facingState.getBlock() == this) {
                if (facingState.getValue((Property)FACING) != direction || facingState.getValue(HALF) != Half.TOP || ((Boolean)facingState.getValue((Property)ROLLED)).booleanValue()) {
                    mustDisappear = true;
                }
            } else {
                mustDisappear = true;
            }
        }
        if (mustDisappear) {
            stateIn = Blocks.AIR.defaultBlockState();
            worldIn.setBlock(currentPos, stateIn, 2);
        }
        return stateIn;
    }

    private BlockState tryMergingWithSprucePlanks(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        if (((Boolean)state.getValue((Property)ROLLED)).booleanValue()) {
            return state;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Block blockDown = worldIn.getBlockState(pos.below()).getBlock();
        Block blockDownAdjacent = worldIn.getBlockState(pos.relative(facing).below()).getBlock();
        if (blockDown == Blocks.SPRUCE_PLANKS && blockDownAdjacent == Blocks.SPRUCE_PLANKS) {
            worldIn.setBlock(pos.below(), (BlockState)((BlockState)DoTBBlocksRegistry.INSTANCE.TATAMI_FLOOR.get().defaultBlockState().setValue((Property)TatamiFloorBlock.FACING, (Comparable)facing)).setValue(TatamiFloorBlock.HALF, (Comparable)((Half)state.getValue(HALF))), 10);
            worldIn.setBlock(pos.relative(facing).below(), (BlockState)((BlockState)DoTBBlocksRegistry.INSTANCE.TATAMI_FLOOR.get().defaultBlockState().setValue((Property)TatamiFloorBlock.FACING, (Comparable)facing)).setValue(TatamiFloorBlock.HALF, (Comparable)(state.getValue(HALF) == Half.TOP ? Half.BOTTOM : Half.TOP)), 10);
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.isCrouching()) {
            int stack = (Integer)state.getValue((Property)STACK);
            boolean isRolled = (Boolean)state.getValue((Property)ROLLED);
            if (isRolled && stack == 1 && worldIn.getBlockState(pos.below()).is(DoTBTags.INSTANCE.COVERED_BLOCKS)) {
                return InteractionResult.PASS;
            }
            if ((Integer)state.getValue((Property)STACK) > 1) {
                state = (BlockState)state.setValue((Property)STACK, (Comparable)Integer.valueOf(stack - 1));
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)this.asItem()));
            } else {
                state = (BlockState)state.setValue((Property)ROLLED, (Comparable)Boolean.valueOf(!isRolled));
                Direction facing = (Direction)state.getValue((Property)FACING);
                if (isRolled) {
                    if (!worldIn.isEmptyBlock(pos.relative(facing)) || worldIn.isEmptyBlock(pos.relative(facing).below()) || worldIn.getBlockState(pos.below().relative(facing)).is(DoTBTags.INSTANCE.COVERED_BLOCKS)) {
                        return InteractionResult.PASS;
                    }
                    worldIn.setBlock(pos.relative(facing), (BlockState)state.setValue(HALF, (Comparable)Half.BOTTOM), 2);
                } else if (state.getValue(HALF) == Half.BOTTOM) {
                    state = (BlockState)((BlockState)state.setValue(HALF, (Comparable)Half.TOP)).setValue((Property)FACING, (Comparable)facing.getOpposite());
                }
            }
            state = this.updateShape(state, Direction.DOWN, worldIn.getBlockState(pos.below()), (LevelAccessor)worldIn, pos, pos.below());
            worldIn.setBlock(pos, state, 2);
            worldIn.playSound(player, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS, (this.soundType.getVolume() + 1.0f) / 2.0f, this.soundType.getPitch() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        if (itemstack.getItem() == this.asItem()) {
            if (!((Boolean)state.getValue((Property)ROLLED)).booleanValue() || (Integer)state.getValue((Property)STACK) == 3) {
                return false;
            }
            return useContext.replacingClickedOnBlock();
        }
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getOpposite())).setValue(HALF, (Comparable)(state.getValue(HALF) == Half.TOP ? Half.BOTTOM : Half.TOP));
            }
            case FRONT_BACK: {
                return (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getOpposite());
            }
        }
        return super.mirror(state, mirrorIn);
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, this, new String[0]);
    }
}

