/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.roman;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class MarbleStatueBlock
extends WaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty MULTIBLOCK = BlockStatePropertiesAA.MULTIBLOCK_0_2;

    public MarbleStatueBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.DESTROY), VoxelShapes.MARBLE_STATUE_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)MULTIBLOCK, (Comparable)Integer.valueOf(0))).setValue((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, MULTIBLOCK});
    }

    public void playerWillDestroy(Level worldIn, BlockPos blockPosIn, BlockState blockStateIn, Player playerEntityIn) {
        int multiblockValue;
        if (!worldIn.isClientSide() && playerEntityIn.isCreative() && (multiblockValue = ((Integer)blockStateIn.getValue((Property)MULTIBLOCK)).intValue()) > 0) {
            BlockPos blockPos = blockPosIn.below(multiblockValue);
            BlockState blockState = worldIn.getBlockState(blockPos);
            worldIn.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
            worldIn.levelEvent(playerEntityIn, 2001, blockPos, Block.getId((BlockState)blockState));
        }
        super.playerWillDestroy(worldIn, blockPosIn, blockStateIn, playerEntityIn);
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Integer)state.getValue((Property)MULTIBLOCK) == 2 ? 1 : 0;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (!level.getBlockState(pos.above()).canBeReplaced(context) || !level.getBlockState(pos.above(2)).canBeReplaced(context)) {
            return null;
        }
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos abovePos = pos.above();
        worldIn.setBlock(abovePos, (BlockState)((BlockState)state.setValue((Property)MULTIBLOCK, (Comparable)Integer.valueOf(1))).setValue((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.getFluidState(abovePos).getType() == Fluids.WATER)), 10);
        abovePos = abovePos.above();
        worldIn.setBlock(abovePos, (BlockState)((BlockState)state.setValue((Property)MULTIBLOCK, (Comparable)Integer.valueOf(2))).setValue((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.getFluidState(abovePos).getType() == Fluids.WATER)), 10);
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing.getAxis().isHorizontal()) {
            return stateIn;
        }
        int multipart = (Integer)stateIn.getValue((Property)MULTIBLOCK);
        if (facing == Direction.UP && multipart < 2 && facingState.getBlock() == this && facingState.getValue((Property)FACING) == stateIn.getValue((Property)FACING) && (Integer)facingState.getValue((Property)MULTIBLOCK) == multipart + 1) {
            return stateIn;
        }
        if (facing == Direction.DOWN && multipart > 0 && facingState.getBlock() == this && facingState.getValue((Property)FACING) == stateIn.getValue((Property)FACING) && (Integer)facingState.getValue((Property)MULTIBLOCK) == multipart - 1) {
            return stateIn;
        }
        return Blocks.AIR.defaultBlockState();
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

