/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.PergolaBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class BeamBlock
extends PergolaBlock {
    public static final BooleanProperty BOTTOM = BlockStateProperties.BOTTOM;

    public BeamBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS_Z, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BeamBlock(BlockBehaviour.Properties properties) {
        this(properties, VoxelShapes.BEAM_SHAPES);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BOTTOM});
    }

    public boolean isBeamBottom(BlockState state, BlockState stateUnder) {
        if (((Boolean)state.getValue((Property)AXIS_Y)).booleanValue() && stateUnder.getBlock() instanceof BeamBlock) {
            return (Boolean)stateUnder.getValue((Property)AXIS_Y) == false;
        }
        return true;
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = super.getShapeIndex(state, worldIn, pos, context);
        if (((Boolean)state.getValue((Property)AXIS_Y)).booleanValue() && ((Boolean)state.getValue((Property)BOTTOM)).booleanValue()) {
            index += 4;
        }
        return index;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        if (((Boolean)state.getValue((Property)AXIS_Y)).booleanValue()) {
            BlockState stateUnder = context.getLevel().getBlockState(context.getClickedPos().below());
            return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBeamBottom(state, stateUnder)));
        }
        return state;
    }

    @NotNull
    public InteractionResult use(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (player.isCrouching()) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)BOTTOM) == false)), 10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nonnull
    public BlockStatePropertiesAA.PillarConnection getBlockPillarConnectionAbove(BlockState state) {
        return (Boolean)state.getValue((Property)AXIS_Y) != false ? BlockStatePropertiesAA.PillarConnection.TEN_PX : BlockStatePropertiesAA.PillarConnection.NOTHING;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable BlockGetter worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "beam");
    }
}

