/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.IBlockSpecialDisplay;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.Utils;

public abstract class CandleLampBlock
extends WaterloggedBlock
implements IBlockSpecialDisplay {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public CandleLampBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT});
    }

    public void animateLitCandle(BlockState stateIn, Level worldIn, BlockPos pos, double x, double y, double z) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.getX() + x;
            double d1 = (double)pos.getY() + y;
            double d2 = (double)pos.getZ() + z;
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.01, 0.0);
        }
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return Utils.changeBlockLitStateWithItemOrCreativePlayer(state, worldIn, pos, player, handIn) >= 0 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public void onProjectileHit(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        int activation = -1;
        if (!((Boolean)state.getValue((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() && !((Boolean)state.getValue((Property)LIT)).booleanValue() && (projectile instanceof AbstractArrow && ((AbstractArrow)projectile).isOnFire() || projectile instanceof Fireball)) {
            activation = 1;
        } else if (((Boolean)state.getValue((Property)LIT)).booleanValue() && (projectile instanceof Snowball || projectile instanceof ThrowableProjectile && PotionUtils.getPotion((ItemStack)((ThrowableItemProjectile)projectile).getItem()).getEffects().size() <= 0)) {
            activation = 0;
        }
        if (activation >= 0) {
            boolean isActivated;
            BlockPos pos = hit.getBlockPos();
            boolean bl = isActivated = activation == 1;
            if (!worldIn.isClientSide()) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(isActivated)), 10);
                worldIn.playSound(null, pos, isActivated ? SoundEvents.FIRE_AMBIENT : SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!isActivated && worldIn.isClientSide()) {
                for (int i = 0; i < worldIn.random.nextInt(1) + 1; ++i) {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (double)(worldIn.random.nextFloat() / 4.0f), 2.5E-5, (double)(worldIn.random.nextFloat() / 4.0f));
                }
            }
        }
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluid) {
        if (((Boolean)state.getValue((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() || fluid.getType() != Fluids.WATER) {
            return false;
        }
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            world.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 10);
        world.scheduleTick(pos, fluid.getType(), fluid.getType().getTickDelay((LevelReader)world));
        return true;
    }

    @Override
    public boolean emitsLight() {
        return true;
    }
}

