/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedHorizontalBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.jetbrains.annotations.NotNull;

public class ConnectedHorizontalBlock
extends WaterloggedHorizontalBlock {
    public static final EnumProperty<BlockStatePropertiesAA.HorizontalConnection> HORIZONTAL_CONNECTION = BlockStatePropertiesAA.HORIZONTAL_CONNECTION;

    public ConnectedHorizontalBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HORIZONTAL_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.HorizontalConnection.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HORIZONTAL_CONNECTION});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = ((BlockStatePropertiesAA.HorizontalConnection)((Object)state.getValue(HORIZONTAL_CONNECTION))).getIndex();
        return index + ((Direction)state.getValue((Property)FACING)).get2DDataValue() * 4;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return (BlockState)state.setValue(HORIZONTAL_CONNECTION, (Comparable)((Object)this.getLineState((LevelAccessor)context.getLevel(), context.getClickedPos(), state)));
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing.getAxis() == ((Direction)stateIn.getValue((Property)FACING)).getClockWise().getAxis() ? (BlockState)stateIn.setValue(HORIZONTAL_CONNECTION, (Comparable)((Object)this.getLineState(worldIn, currentPos, stateIn))) : stateIn;
    }

    private BlockStatePropertiesAA.HorizontalConnection getLineState(LevelAccessor worldIn, BlockPos pos, BlockState stateIn) {
        Direction direction = ((Direction)stateIn.getValue((Property)FACING)).getClockWise();
        if (this.isConnectible(worldIn, pos.relative(direction, -1), stateIn)) {
            return this.isConnectible(worldIn, pos.relative(direction), stateIn) ? BlockStatePropertiesAA.HorizontalConnection.BOTH : BlockStatePropertiesAA.HorizontalConnection.LEFT;
        }
        return this.isConnectible(worldIn, pos.relative(direction), stateIn) ? BlockStatePropertiesAA.HorizontalConnection.RIGHT : BlockStatePropertiesAA.HorizontalConnection.NONE;
    }

    private boolean isConnectible(LevelAccessor worldIn, BlockPos offset, BlockState stateIn) {
        BlockState state = worldIn.getBlockState(offset);
        if (state.getBlock() == this) {
            return state.getValue((Property)FACING) == stateIn.getValue((Property)FACING);
        }
        return false;
    }
}

