/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.BlockDoT;
import org.dawnoftime.dawnoftime.util.VoxelShapes;

public class HorizontalAxisBlock
extends BlockDoT {
    private static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public HorizontalAxisBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X));
    }

    public HorizontalAxisBlock(BlockBehaviour.Properties properties) {
        this(properties, VoxelShapes.FULL_SHAPE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HORIZONTAL_AXIS});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction.Axis clicked = context.getClickedFace().getAxis();
        if (clicked.isHorizontal()) {
            return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)clicked);
        }
        return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)context.getHorizontalDirection().getAxis());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) {
            return (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)(state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return super.rotate(state, rot);
    }
}

