/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class LatticeBlock
extends WaterloggedBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;

    public LatticeBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.LATTICE_FOUR_SIDES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            index += 8;
        }
        if (index > 14) {
            index = 0;
        }
        return index;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.getBlock() != this) {
            state = super.getStateForPlacement(context);
        }
        if (state == null) {
            return null;
        }
        return switch (context.getHorizontalDirection()) {
            case Direction.WEST -> (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(true));
            case Direction.NORTH -> (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(true));
            case Direction.EAST -> (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(true));
            default -> (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true));
        };
    }

    public boolean canBeReplaced(@NotNull BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        if (useContext.getPlayer() != null && useContext.getPlayer().isCrouching()) {
            return false;
        }
        if (itemstack.getItem() == this.asItem()) {
            Direction newDirection = useContext.getHorizontalDirection();
            return switch (newDirection) {
                case Direction.WEST -> {
                    if (!((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.NORTH -> {
                    if (!((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.EAST -> {
                    if (!((Boolean)state.getValue((Property)EAST)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                default -> (Boolean)state.getValue((Property)SOUTH) == false;
            };
        }
        return false;
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        boolean n = (Boolean)state.getValue((Property)NORTH);
        boolean e = (Boolean)state.getValue((Property)EAST);
        boolean s = (Boolean)state.getValue((Property)SOUTH);
        boolean w = (Boolean)state.getValue((Property)WEST);
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(w))).setValue((Property)EAST, (Comparable)Boolean.valueOf(n))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(e))).setValue((Property)WEST, (Comparable)Boolean.valueOf(s));
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(s))).setValue((Property)EAST, (Comparable)Boolean.valueOf(w))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(n))).setValue((Property)WEST, (Comparable)Boolean.valueOf(e));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(e))).setValue((Property)EAST, (Comparable)Boolean.valueOf(s))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(w))).setValue((Property)WEST, (Comparable)Boolean.valueOf(n));
            default -> state;
        };
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        boolean n = (Boolean)state.getValue((Property)NORTH);
        boolean e = (Boolean)state.getValue((Property)EAST);
        boolean s = (Boolean)state.getValue((Property)SOUTH);
        boolean w = (Boolean)state.getValue((Property)WEST);
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(s))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(n))).setValue((Property)EAST, (Comparable)Boolean.valueOf(e))).setValue((Property)WEST, (Comparable)Boolean.valueOf(w));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(w))).setValue((Property)WEST, (Comparable)Boolean.valueOf(e))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(n))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(s));
            default -> state;
        };
    }
}

