/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class SmallShutterBlock
extends WaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<BlockStatePropertiesAA.OpenPosition> OPEN_POSITION = BlockStatePropertiesAA.OPEN_POSITION;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;

    public SmallShutterBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.DESTROY).lightLevel(state -> 1), VoxelShapes.SMALL_SHUTTER_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(OPEN_POSITION, (Comparable)((Object)BlockStatePropertiesAA.OpenPosition.CLOSED))).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, HINGE, OPEN_POSITION, POWERED});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        boolean hinge = state.getValue(HINGE) == DoorHingeSide.RIGHT;
        Direction dir = (Direction)state.getValue((Property)FACING);
        return switch ((BlockStatePropertiesAA.OpenPosition)((Object)state.getValue(OPEN_POSITION))) {
            default -> throw new IncompatibleClassChangeError();
            case BlockStatePropertiesAA.OpenPosition.FULL -> (hinge ? 1 : 2) + 3 * dir.get2DDataValue();
            case BlockStatePropertiesAA.OpenPosition.CLOSED -> 3 * dir.get2DDataValue();
            case BlockStatePropertiesAA.OpenPosition.HALF -> 3 * (hinge ? dir.getClockWise().get2DDataValue() : dir.getCounterClockWise().get2DDataValue());
        };
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        Direction direction = context.getHorizontalDirection();
        BlockPos pos = context.getClickedPos();
        int x = direction.getStepX();
        int z = direction.getStepZ();
        double onX = context.getClickLocation().x - (double)pos.getX();
        double onZ = context.getClickLocation().z - (double)pos.getZ();
        boolean hingeLeft = !(x < 0 && !(onZ >= 0.5) || x > 0 && !(onZ <= 0.5) || z < 0 && !(onX <= 0.5) || z > 0 && !(onX >= 0.5));
        boolean powered = world.hasNeighborSignal(pos) || world.hasNeighborSignal(pos.above());
        BlockState madeState = (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue(HINGE, (Comparable)(hingeLeft ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT))).setValue((Property)FACING, (Comparable)direction)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered));
        return (BlockState)madeState.setValue(OPEN_POSITION, (Comparable)((Object)(powered ? this.getOpenState(madeState, (LevelAccessor)world, pos) : BlockStatePropertiesAA.OpenPosition.CLOSED)));
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Direction hingeDirection;
        Direction direction = (Direction)stateIn.getValue((Property)FACING);
        Direction direction2 = hingeDirection = stateIn.getValue(HINGE) == DoorHingeSide.LEFT ? direction.getCounterClockWise() : direction.getClockWise();
        if (facing == hingeDirection) {
            return (stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos)).getValue(OPEN_POSITION) == BlockStatePropertiesAA.OpenPosition.CLOSED ? stateIn : (BlockState)stateIn.setValue(OPEN_POSITION, (Comparable)((Object)this.getOpenState(stateIn, worldIn, facingPos)));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((BlockStatePropertiesAA.OpenPosition)((Object)state.getValue(OPEN_POSITION))).isOpen()) {
            state = (BlockState)state.setValue(OPEN_POSITION, (Comparable)((Object)BlockStatePropertiesAA.OpenPosition.CLOSED));
        } else {
            Direction hingeDirection = state.getValue(HINGE) == DoorHingeSide.LEFT ? ((Direction)state.getValue((Property)FACING)).getCounterClockWise() : ((Direction)state.getValue((Property)FACING)).getClockWise();
            state = (BlockState)state.setValue(OPEN_POSITION, (Comparable)((Object)this.getOpenState(state, (LevelAccessor)worldIn, pos.relative(hingeDirection))));
        }
        worldIn.setBlock(pos, state, 10);
        worldIn.levelEvent(player, ((BlockStatePropertiesAA.OpenPosition)((Object)state.getValue(OPEN_POSITION))).isOpen() ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        if (((Boolean)state.getValue((Property)WaterloggedBlock.WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return InteractionResult.SUCCESS;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean isPowered = worldIn.hasNeighborSignal(pos);
        if (blockIn != this && isPowered != (Boolean)state.getValue((Property)POWERED)) {
            if (isPowered != ((BlockStatePropertiesAA.OpenPosition)((Object)state.getValue(OPEN_POSITION))).isOpen()) {
                this.playSound(worldIn, pos, isPowered);
            }
            if (isPowered) {
                Direction hingeDirection = state.getValue(HINGE) == DoorHingeSide.LEFT ? ((Direction)state.getValue((Property)FACING)).getCounterClockWise() : ((Direction)state.getValue((Property)FACING)).getClockWise();
                state = (BlockState)state.setValue(OPEN_POSITION, (Comparable)((Object)this.getOpenState(state, (LevelAccessor)worldIn, pos.relative(hingeDirection))));
            } else {
                state = (BlockState)state.setValue(OPEN_POSITION, (Comparable)((Object)BlockStatePropertiesAA.OpenPosition.CLOSED));
            }
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 2);
        }
    }

    protected BlockStatePropertiesAA.OpenPosition getOpenState(BlockState stateIn, LevelAccessor worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos).getCollisionShape((BlockGetter)worldIn, pos).isEmpty() ? BlockStatePropertiesAA.OpenPosition.FULL : BlockStatePropertiesAA.OpenPosition.HALF;
    }

    private void playSound(Level worldIn, BlockPos pos, boolean isOpening) {
        worldIn.levelEvent(null, isOpening ? this.getOpenSound() : this.getCloseSound(), pos, 0);
    }

    private int getCloseSound() {
        return 1012;
    }

    private int getOpenSound() {
        return 1006;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            default: {
                return state;
            }
            case FRONT_BACK: {
                state = this.rotate(state, Rotation.CLOCKWISE_180);
            }
            case LEFT_RIGHT: 
        }
        return (BlockState)state.setValue(HINGE, (Comparable)(state.getValue(HINGE) == DoorHingeSide.RIGHT ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT));
    }

    public int getLightBlock(BlockState p_200011_1_In, BlockGetter p_200011_2_In, BlockPos p_200011_3_In) {
        return 1;
    }

    public boolean useShapeForLightOcclusion(BlockState p_220074_1_In) {
        return false;
    }

    public VoxelShape getOcclusionShape(BlockState p_196247_1_In, BlockGetter p_196247_2_In, BlockPos p_196247_3_In) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState p_200123_1_In, BlockGetter p_200123_2_In, BlockPos p_200123_3_In) {
        return true;
    }
}

