/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.registry.DoTBTags;

public class Utils {
    public static final int HIGHEST_Y = 255;
    public static final Component TOOLTIP_HOLD_SHIFT = Component.translatable((String)"tooltip.dawnoftimebuilder.hold_key").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"tooltip.dawnoftimebuilder.shift").withStyle(ChatFormatting.AQUA));
    public static final String TOOLTIP_COLUMN = "column";
    public static final String TOOLTIP_BEAM = "beam";
    public static final String TOOLTIP_FIREPLACE = "fireplace";
    public static final String TOOLTIP_ADD_COLUMN = "add_column";

    public static boolean isShapeIncludedInShape(VoxelShape testedShape, VoxelShape faceShape, VoxelShape inShape) {
        VoxelShape shapeOnFace = Shapes.join((VoxelShape)testedShape, (VoxelShape)faceShape, (BooleanOp)BooleanOp.AND);
        return !Shapes.joinIsNotEmpty((VoxelShape)shapeOnFace, (VoxelShape)inShape, (BooleanOp)BooleanOp.ONLY_FIRST);
    }

    public static boolean clickedOnLeftHalf(BlockPos clickedPos, Direction dir, Vec3 clickLocation) {
        int dirStepX = dir.getStepX();
        int dirStepZ = dir.getStepZ();
        double diffX = clickLocation.x - (double)clickedPos.getX();
        double diffZ = clickLocation.z - (double)clickedPos.getZ();
        return !(dirStepX < 0 && diffZ < 0.5 || dirStepX > 0 && diffZ > 0.5 || dirStepZ < 0 && diffX > 0.5 || dirStepZ > 0 && diffX < 0.5);
    }

    public static boolean useLighter(Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        ItemStack itemInHand = player.getItemInHand(handIn);
        if (!itemInHand.isEmpty() && itemInHand.is(DoTBTags.INSTANCE.LIGHTERS)) {
            worldIn.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            itemInHand.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(handIn));
            return true;
        }
        return false;
    }

    public static boolean useFireActivatorOnBlockIfPossible(BlockState blockstateIn, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        if (((Boolean)blockstateIn.getValue((Property)WaterloggedBlock.WATERLOGGED)).booleanValue()) {
            return false;
        }
        ItemStack itemStackInHand = player.getItemInHand(handIn);
        if (!itemStackInHand.isEmpty()) {
            Item itemInHand = itemStackInHand.getItem();
            if (itemInHand instanceof FireChargeItem) {
                if (!player.isCreative()) {
                    player.getMainHandItem().shrink(1);
                }
                return true;
            }
            if (itemStackInHand.is(DoTBTags.INSTANCE.LIGHTERS)) {
                worldIn.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.isCreative()) {
                    itemStackInHand.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(handIn));
                }
                return true;
            }
        }
        return false;
    }

    public static boolean useFireStopperIfPossible(BlockState blockstateIn, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        ItemStack mainItemStack = player.getMainHandItem();
        if (player.isCreative()) {
            return true;
        }
        if (mainItemStack.isEmpty()) {
            return false;
        }
        if (mainItemStack.is(DoTBTags.INSTANCE.LIGHTERS)) {
            worldIn.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                mainItemStack.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(handIn));
            }
            return true;
        }
        if (mainItemStack.getItem() instanceof PotionItem && !(mainItemStack.getItem() instanceof SplashPotionItem)) {
            Potion potion = PotionUtils.getPotion((ItemStack)mainItemStack);
            if (potion != null && potion.getEffects().size() <= 0) {
                player.getMainHandItem().shrink(1);
                player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                return true;
            }
        } else if (mainItemStack.getItem() instanceof SnowballItem) {
            player.getMainHandItem().shrink(1);
            return true;
        }
        return false;
    }

    public static int changeBlockLitStateWithItemOrCreativePlayer(BlockState stateIn, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        int activation;
        block8: {
            activation = -1;
            if (((Boolean)stateIn.getValue((Property)BlockStateProperties.LIT)).booleanValue() && Utils.useFireStopperIfPossible(stateIn, worldIn, pos, player, handIn)) {
                activation = 0;
            } else if (!((Boolean)stateIn.getValue((Property)BlockStateProperties.LIT)).booleanValue() && Utils.useFireActivatorOnBlockIfPossible(stateIn, worldIn, pos, player, handIn)) {
                activation = 1;
            }
            if (activation < 0) break block8;
            boolean isActivated = activation == 1;
            worldIn.setBlock(pos, (BlockState)stateIn.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(isActivated)), 10);
            worldIn.playSound(null, pos, isActivated ? SoundEvents.FIRE_AMBIENT : SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (worldIn.isClientSide) {
                if (!isActivated) {
                    for (int i = 0; i < worldIn.random.nextInt(4) + 2; ++i) {
                        worldIn.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (double)(worldIn.random.nextFloat() / 4.0f), 2.5E-5, (double)(worldIn.random.nextFloat() / 4.0f));
                    }
                } else {
                    for (int i = 0; i < worldIn.random.nextInt(4) + 2; ++i) {
                        worldIn.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (double)(worldIn.random.nextFloat() / 4.0f), 2.5E-5, (double)(worldIn.random.nextFloat() / 4.0f));
                    }
                }
            }
        }
        return activation;
    }

    public static void addTooltip(List<Component> tooltip, @Nonnull Item item, String ... tooltipNames) {
        ResourceLocation itemName = item.builtInRegistryHolder().key().location();
        if (itemName != null) {
            String[] tts = new String[tooltipNames.length + 1];
            System.arraycopy(tooltipNames, 0, tts, 0, tooltipNames.length);
            tts[tooltipNames.length] = itemName.getPath();
            Utils.addTooltip(tooltip, tts);
        }
    }

    public static void addTooltip(List<Component> tooltip, @Nonnull Block block, String ... tooltipNames) {
        ResourceLocation itemName = block.builtInRegistryHolder().key().location();
        if (itemName != null) {
            String[] tts = new String[tooltipNames.length + 1];
            System.arraycopy(tooltipNames, 0, tts, 0, tooltipNames.length);
            tts[tooltipNames.length] = itemName.getPath();
            Utils.addTooltip(tooltip, tts);
        }
    }

    public static void addTooltip(List<Component> tooltip, String ... tooltipNames) {
        if (Screen.hasShiftDown()) {
            for (String tooltipName : tooltipNames) {
                tooltip.add((Component)Component.translatable((String)("tooltip.dawnoftimebuilder." + tooltipName)).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add(TOOLTIP_HOLD_SHIFT);
        }
    }
}

