/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.general.FireplaceBlock;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalBlock;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalSidedBlock;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalSidedPlanFireplaceBlock;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.jetbrains.annotations.NotNull;

public class ChimneyBlockDoT
extends ConnectedVerticalBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public ChimneyBlockDoT(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.LIT});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos belowBlockPos;
        BlockState state = super.getStateForPlacement(context);
        Level world = context.getLevel();
        BlockState blockState = world.getBlockState(belowBlockPos = context.getClickedPos().below());
        if (blockState.getBlock() instanceof ChimneyBlockDoT) {
            return (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)));
        }
        if (blockState.getBlock() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
            BlockState foundBlockState;
            belowBlockPos = belowBlockPos.below();
            while ((foundBlockState = world.getBlockState(belowBlockPos)).getBlock() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
                blockState = foundBlockState;
                belowBlockPos = belowBlockPos.below();
            }
            return (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)));
        }
        return state;
    }

    @Override
    public InteractionResult use(BlockState blockStateIn, Level worldIn, BlockPos blockPosIn, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (super.use(blockStateIn, worldIn, blockPosIn, player, handIn, hit).equals((Object)InteractionResult.SUCCESS)) {
            return InteractionResult.SUCCESS;
        }
        int activation = Utils.changeBlockLitStateWithItemOrCreativePlayer(blockStateIn, worldIn, blockPosIn, player, handIn);
        if (activation >= 0) {
            boolean isActivated = activation == 1;
            ChimneyBlockDoT.updateAllChimneyConductParts(isActivated, blockStateIn, blockPosIn, worldIn);
            ChimneyBlockDoT.updateFireplace(isActivated, blockPosIn, worldIn);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onProjectileHit(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        int activation = -1;
        if (!((Boolean)state.getValue((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() && !((Boolean)state.getValue((Property)FireplaceBlock.LIT)).booleanValue() && (projectile instanceof Arrow && ((Arrow)projectile).isOnFire() || projectile instanceof Fireball)) {
            activation = 1;
        } else if (((Boolean)state.getValue((Property)FireplaceBlock.LIT)).booleanValue() && (projectile instanceof Snowball || projectile instanceof ThrowableProjectile && PotionUtils.getPotion((ItemStack)((ThrowableItemProjectile)projectile).getItem()).getEffects().size() <= 0)) {
            activation = 0;
        }
        if (activation >= 0) {
            boolean isActivated;
            BlockPos pos = hit.getBlockPos();
            boolean bl = isActivated = activation == 1;
            if (!worldIn.isClientSide()) {
                ChimneyBlockDoT.updateAllChimneyConductParts(isActivated, state, pos, worldIn);
                worldIn.playSound(null, pos, isActivated ? SoundEvents.FIRE_AMBIENT : SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!isActivated && worldIn.isClientSide()) {
                for (int i = 0; i < worldIn.random.nextInt(1) + 1; ++i) {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (double)(worldIn.random.nextFloat() / 4.0f), 2.5E-5, (double)(worldIn.random.nextFloat() / 4.0f));
                }
            }
        }
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateIn.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            return;
        }
        if (stateIn.getValue(ConnectedVerticalBlock.VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.UNDER || stateIn.getValue(ConnectedVerticalBlock.VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.NONE) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, true, (double)pos.getX() + rand.nextDouble() * 0.5 + 0.25, (double)pos.getY() + rand.nextDouble() * 0.5 + 0.3, (double)pos.getZ() + rand.nextDouble() * 0.5 + 0.25, 0.0, 0.07, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)pos.getX() + rand.nextDouble() * 0.5 + 0.25, (double)pos.getY() + rand.nextDouble() * 0.5 + 0.3, (double)pos.getZ() + rand.nextDouble() * 0.5 + 0.25, 0.0, 0.04, 0.0);
        }
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facingState.getBlock() instanceof ChimneyBlockDoT || facingState.getBlock() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
            stateIn.setValue((Property)LIT, (Comparable)((Boolean)facingState.getValue((Property)LIT)));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "fireplace");
    }

    public static void updateAllChimneyConductParts(boolean isActivatedIn, BlockState stateIn, BlockPos blockPosIn, Level worldIn) {
        stateIn = (BlockState)stateIn.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(isActivatedIn));
        worldIn.setBlock(blockPosIn, stateIn, 10);
        ChimneyBlockDoT.updateIsActivatedInAllPartsOfBottom(isActivatedIn, stateIn, blockPosIn, worldIn);
        ChimneyBlockDoT.updateIsActivatedInAllPartsOfTop(isActivatedIn, stateIn, blockPosIn, worldIn);
    }

    public static void updateIsActivatedInAllPartsOfBottom(boolean isActivatedIn, BlockState stateIn, BlockPos blockPosIn, Level worldIn) {
        BlockState blockState = null;
        BlockPos blockPos = blockPosIn;
        while ((blockState = worldIn.getBlockState(blockPos = blockPos.below())) != null && blockState.getBlock() instanceof ChimneyBlockDoT) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(isActivatedIn));
            worldIn.setBlock(blockPos, blockState, 10);
        }
    }

    public static void updateIsActivatedInAllPartsOfTop(boolean isActivatedIn, BlockState stateIn, BlockPos blockPosIn, Level worldIn) {
        BlockState blockState = null;
        BlockPos blockPos = blockPosIn;
        while ((blockState = worldIn.getBlockState(blockPos = blockPos.above())) != null && blockState.getBlock() instanceof ChimneyBlockDoT) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(isActivatedIn));
            worldIn.setBlock(blockPos, blockState, 10);
        }
    }

    public static void updateFireplace(boolean isActivatedIn, BlockPos blockPosIn, Level worldIn) {
        BlockState blockState = null;
        BlockPos blockPos = blockPosIn;
        while ((blockState = worldIn.getBlockState(blockPos = blockPos.below())) != null && blockState.getBlock() instanceof ChimneyBlockDoT) {
        }
        while ((blockState = worldIn.getBlockState(blockPos = blockPos.below())) != null && blockState.getBlock() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
            BlockStatePropertiesAA.VerticalConnection verticalConnection = (BlockStatePropertiesAA.VerticalConnection)((Object)blockState.getValue(ConnectedVerticalBlock.VERTICAL_CONNECTION));
            if (verticalConnection == null || !BlockStatePropertiesAA.VerticalConnection.ABOVE.equals((Object)verticalConnection)) continue;
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(isActivatedIn));
            worldIn.setBlock(blockPos, blockState, 10);
            Direction direction = (Direction)blockState.getValue((Property)ConnectedVerticalSidedBlock.FACING);
            worldIn.getBlockState(blockPos.relative(direction.getCounterClockWise())).neighborChanged(worldIn, blockPos.relative(direction.getCounterClockWise()), blockState.getBlock(), blockPos, false);
            worldIn.getBlockState(blockPos.relative(direction.getClockWise())).neighborChanged(worldIn, blockPos.relative(direction.getClockWise()), blockState.getBlock(), blockPos, false);
        }
    }
}

