/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.PaneBlockDoT;

public class PillarPaneBlock
extends PaneBlockDoT {
    private static final VoxelShape[] SHAPES_PILLAR = PillarPaneBlock.makeShapesPillar(true);
    private static final VoxelShape[] SHAPES_NO_PILLAR = PillarPaneBlock.makeShapesPillar(false);

    public PillarPaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean pillar = (Boolean)state.getValue((Property)NORTH) != false && (Boolean)state.getValue((Property)EAST) != false || (Boolean)state.getValue((Property)EAST) != false && (Boolean)state.getValue((Property)SOUTH) != false || (Boolean)state.getValue((Property)SOUTH) != false && (Boolean)state.getValue((Property)WEST) != false || (Boolean)state.getValue((Property)WEST) != false && (Boolean)state.getValue((Property)NORTH) != false;
        return pillar ? SHAPES_PILLAR[this.getAABBIndex(state)] : SHAPES_NO_PILLAR[this.getAABBIndex(state)];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }

    private static VoxelShape[] makeShapesPillar(boolean with_pillar) {
        VoxelShape poll = with_pillar ? Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0) : Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
        VoxelShape side_A = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
        VoxelShape side_B = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
        VoxelShape side_C = Block.box((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
        VoxelShape side_D = Block.box((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        VoxelShape angle_AD = Shapes.or((VoxelShape)side_A, (VoxelShape)side_D);
        VoxelShape angle_BC = Shapes.or((VoxelShape)side_B, (VoxelShape)side_C);
        VoxelShape[] all_vs = new VoxelShape[]{Shapes.empty(), side_B, side_C, angle_BC, side_A, Shapes.or((VoxelShape)side_B, (VoxelShape)side_A), Shapes.or((VoxelShape)side_C, (VoxelShape)side_A), Shapes.or((VoxelShape)angle_BC, (VoxelShape)side_A), side_D, Shapes.or((VoxelShape)side_B, (VoxelShape)side_D), Shapes.or((VoxelShape)side_C, (VoxelShape)side_D), Shapes.or((VoxelShape)angle_BC, (VoxelShape)side_D), angle_AD, Shapes.or((VoxelShape)side_B, (VoxelShape)angle_AD), Shapes.or((VoxelShape)side_C, (VoxelShape)angle_AD), Shapes.or((VoxelShape)angle_BC, (VoxelShape)angle_AD)};
        for (int i = 0; i < 16; ++i) {
            all_vs[i] = Shapes.or((VoxelShape)poll, (VoxelShape)all_vs[i]);
        }
        return all_vs;
    }
}

