/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.dawnoftime.dawnoftime.DoTBCommon;
import org.dawnoftime.dawnoftime.client.gui.creative.CreativeInventoryCategories;
import org.dawnoftime.dawnoftime.mixin.api.CreativeScreen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CategoryButton
extends Button {
    private final CreativeScreen parent;
    private boolean selected = false;
    private static final ResourceLocation[] BUTTON_ICONS = CategoryButton.fillButtonIcons();
    private static final Tooltip[] BUTTON_TOOLTIPS = CategoryButton.fillButtonTooltips();
    private final int index;

    public CategoryButton(int x, int y, int index, Button.OnPress pressable, CreativeScreen parent) {
        super(x, y, 32, 28, (Component)Component.empty(), pressable, DEFAULT_NARRATION);
        this.index = index;
        this.parent = parent;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int getCategoryID() {
        return this.parent.dOTBuilder$getPage() * 4 + this.index;
    }

    @Nullable
    public Tooltip getTooltipForCategory() {
        int id = this.getCategoryID();
        if (id < BUTTON_TOOLTIPS.length && id >= 0) {
            return BUTTON_TOOLTIPS[id];
        }
        return null;
    }

    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.active) {
            PoseStack ps = pGuiGraphics.pose();
            ps.pushPose();
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            pGuiGraphics.blit(DoTBCommon.CREATIVE_ICONS, this.getX() - 1, this.getY(), 0, this.selected ? 0 : 28, 31, 28);
            RenderSystem.disableBlend();
            ps.popPose();
            ps.pushPose();
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            pGuiGraphics.blit(BUTTON_ICONS[this.getCategoryID()], this.getX() + (this.selected ? 6 : 9), this.getY() + 6, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.disableBlend();
            ps.popPose();
        }
    }

    private static ResourceLocation[] fillButtonIcons() {
        int number = CreativeInventoryCategories.values().length;
        ResourceLocation[] table = new ResourceLocation[number];
        for (int i = 0; i < number; ++i) {
            table[i] = new ResourceLocation("dawnoftimebuilder", "textures/item/logo_" + CreativeInventoryCategories.values()[i].getName() + ".png");
        }
        return table;
    }

    private static Tooltip[] fillButtonTooltips() {
        int number = CreativeInventoryCategories.values().length;
        Tooltip[] tooltips = new Tooltip[number];
        for (int i = 0; i < number; ++i) {
            tooltips[i] = Tooltip.create((Component)Component.translatable((String)("gui.dawnoftimebuilder." + CreativeInventoryCategories.values()[i].getName())));
        }
        return tooltips;
    }

    @Nullable
    public Tooltip getTooltip() {
        return this.active ? super.getTooltip() : null;
    }

    protected ClientTooltipPositioner createTooltipPositioner() {
        return DefaultTooltipPositioner.INSTANCE;
    }
}

