/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightleaf.Leaf;

import dev.atrox.lightleaf.LightLeaf;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LeafListener
implements Listener {
    private final LightLeaf plugin;
    private final Random random = new Random();
    private final ConcurrentMap<Block, Long> blockCooldown = new ConcurrentHashMap<Block, Long>();

    public LeafListener(LightLeaf plugin) {
        this.plugin = plugin;
        this.startLeafEffectsTask();
    }

    private void startLeafEffectsTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : LeafListener.this.plugin.getServer().getOnlinePlayers()) {
                    LeafListener.this.handlePlayerLeafEffects(player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 100L);
    }

    private void handlePlayerLeafEffects(Player player) {
        int radius = 4;
        Block playerBlock = player.getLocation().getBlock();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block block = playerBlock.getRelative(x, y, z);
                    if (!this.isLeafBlock(block) || !this.isBlockCooldownOver(block) || !this.shouldProcessEffect(player.getLocation().distance(block.getLocation()))) continue;
                    this.spawnParticles(block);
                    this.updateBlockCooldown(block);
                }
            }
        }
    }

    private boolean isLeafBlock(Block block) {
        Material material = block.getType();
        return material == Material.ACACIA_LEAVES || material == Material.BIRCH_LEAVES || material == Material.DARK_OAK_LEAVES || material == Material.JUNGLE_LEAVES || material == Material.OAK_LEAVES || material == Material.SPRUCE_LEAVES;
    }

    private boolean shouldProcessEffect(double distance) {
        if (distance <= 10.0) {
            return this.random.nextDouble() < 0.1;
        }
        if (distance <= 20.0) {
            return this.random.nextDouble() < 0.05;
        }
        return this.random.nextDouble() < 0.02;
    }

    private void spawnParticles(Block block) {
        if (this.plugin.getConfig().getBoolean("particleEnabled", true)) {
            int particleAmount = this.plugin.getConfig().getInt("particleAmount", 5);
            block.getWorld().spawnParticle(Particle.SPORE_BLOSSOM_AIR, block.getLocation().add(0.5, 0.5, 0.5), particleAmount, 0.25, 0.25, 0.25, 0.0);
        }
    }

    private boolean isBlockCooldownOver(Block block) {
        return !this.blockCooldown.containsKey(block) || System.currentTimeMillis() - (Long)this.blockCooldown.get(block) > 10000L;
    }

    private void updateBlockCooldown(Block block) {
        this.blockCooldown.put(block, System.currentTimeMillis());
    }
}

