/*
 * Decompiled with CFR 0.152.
 */
package com.example.deathlimiter;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DeathLimiter
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private Map<UUID, Integer> playerDeaths;
    private String banMessage;
    private int maxDeaths;
    private boolean broadcastBan;
    private boolean notifyOnJoin;
    private String joinNotification;
    private boolean notifyOnDeath;
    private String deathNotification;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.playerDeaths = new HashMap<UUID, Integer>();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("undeath").setExecutor(new UndeathCommand());
        this.getLogger().info("DeathLimiter has been enabled!");
    }

    @Override
    public void onDisable() {
        this.savePlayerData();
        this.getLogger().info("DeathLimiter has been disabled!");
    }

    private void loadConfig() {
        this.maxDeaths = this.config.getInt("max-deaths", 3);
        this.banMessage = ChatColor.translateAlternateColorCodes('&', this.config.getString("ban-message", "&cYou have been banned for exceeding the maximum number of deaths (&4" + this.maxDeaths + "&c)."));
        this.broadcastBan = this.config.getBoolean("broadcast-ban", true);
        this.notifyOnJoin = this.config.getBoolean("notify-on-join", true);
        this.joinNotification = ChatColor.translateAlternateColorCodes('&', this.config.getString("join-notification", "&7You have &c{deaths}&7/&c{max-deaths} &7deaths."));
        this.notifyOnDeath = this.config.getBoolean("notify-on-death", true);
        this.deathNotification = ChatColor.translateAlternateColorCodes('&', this.config.getString("death-notification", "&7You have &c{deaths}&7/&c{max-deaths} &7deaths. Be careful!"));
        if (this.config.contains("player-deaths")) {
            for (String uuidString : this.config.getConfigurationSection("player-deaths").getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidString);
                    int deaths = this.config.getInt("player-deaths." + uuidString);
                    this.playerDeaths.put(uuid, deaths);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid UUID in config: " + uuidString);
                }
            }
        }
    }

    private void savePlayerData() {
        for (Map.Entry<UUID, Integer> entry : this.playerDeaths.entrySet()) {
            this.config.set("player-deaths." + entry.getKey().toString(), entry.getValue());
        }
        this.saveConfig();
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        UUID uuid = player.getUniqueId();
        int deaths = this.playerDeaths.getOrDefault(uuid, 0) + 1;
        this.playerDeaths.put(uuid, deaths);
        if (this.notifyOnDeath) {
            String message = this.deathNotification.replace("{deaths}", String.valueOf(deaths)).replace("{max-deaths}", String.valueOf(this.maxDeaths));
            player.sendMessage(message);
        }
        if (deaths >= this.maxDeaths) {
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                player.kickPlayer(this.banMessage);
                Bukkit.getBanList(BanList.Type.NAME).addBan((String)player.getName(), this.banMessage, (Date)null, "DeathLimiter");
                if (this.broadcastBan) {
                    Bukkit.broadcastMessage(String.valueOf((Object)ChatColor.RED) + player.getName() + " has been banned for exceeding the maximum number of deaths (" + this.maxDeaths + ").");
                }
                this.getLogger().info(player.getName() + " has been banned for exceeding the death limit.");
            });
        }
        this.config.set("player-deaths." + uuid.toString(), deaths);
        this.saveConfig();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.playerDeaths.containsKey(uuid)) {
            this.playerDeaths.put(uuid, 0);
        }
        if (this.notifyOnJoin) {
            int deaths = this.playerDeaths.getOrDefault(uuid, 0);
            String message = this.joinNotification.replace("{deaths}", String.valueOf(deaths)).replace("{max-deaths}", String.valueOf(this.maxDeaths));
            player.sendMessage(message);
        }
    }

    private class UndeathCommand
    implements CommandExecutor {
        private UndeathCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!sender.hasPermission("deathlimiter.undeath")) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length < 1) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /undeath <player>");
                return true;
            }
            String playerName = args[0];
            Player targetPlayer = Bukkit.getPlayer(playerName);
            UUID uuid = null;
            if (targetPlayer != null) {
                uuid = targetPlayer.getUniqueId();
            } else {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer(playerName);
                if (offlinePlayer.hasPlayedBefore()) {
                    uuid = offlinePlayer.getUniqueId();
                }
            }
            if (uuid == null) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Player not found!");
                return true;
            }
            DeathLimiter.this.playerDeaths.put(uuid, 0);
            DeathLimiter.this.config.set("player-deaths." + uuid.toString(), 0);
            DeathLimiter.this.saveConfig();
            Bukkit.getBanList(BanList.Type.NAME).pardon(playerName);
            sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Death count reset for " + playerName + "! They have been unbanned if they were banned.");
            return true;
        }
    }
}

