/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.registry.RegistryAware;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Villager
extends AbstractVillager {
    @NotNull
    public Profession getProfession();

    public void setProfession(@NotNull Profession var1);

    @NotNull
    public Type getVillagerType();

    public void setVillagerType(@NotNull Type var1);

    public int getVillagerLevel();

    public void setVillagerLevel(int var1);

    public int getVillagerExperience();

    public void setVillagerExperience(int var1);

    public boolean sleep(@NotNull Location var1);

    public void wakeup();

    public void shakeHead();

    @Nullable
    public ZombieVillager zombify();

    public int getReputation(@NotNull UUID var1, @NotNull ReputationType var2);

    public int getWeightedReputation(@NotNull UUID var1, @NotNull ReputationType var2);

    public int getReputation(@NotNull UUID var1);

    public void addReputation(@NotNull UUID var1, @NotNull ReputationType var2, int var3);

    public void addReputation(@NotNull UUID var1, @NotNull ReputationType var2, int var3, @NotNull ReputationEvent var4);

    public void removeReputation(@NotNull UUID var1, @NotNull ReputationType var2, int var3);

    public void removeReputation(@NotNull UUID var1, @NotNull ReputationType var2, int var3, @NotNull ReputationEvent var4);

    public void setReputation(@NotNull UUID var1, @NotNull ReputationType var2, int var3);

    public void setReputation(@NotNull UUID var1, @NotNull ReputationType var2, int var3, @NotNull ReputationEvent var4);

    public void setGossipDecayTime(long var1);

    public long getGossipDecayTime();

    public static interface ReputationEvent {
        public static final ReputationEvent ZOMBIE_VILLAGER_CURED = ReputationEvent.getReputationEvent("zombie_villager_cured");
        public static final ReputationEvent TRADE = ReputationEvent.getReputationEvent("trade");
        public static final ReputationEvent VILLAGER_HURT = ReputationEvent.getReputationEvent("villager_hurt");
        public static final ReputationEvent VILLAGER_KILLED = ReputationEvent.getReputationEvent("villager_killed");
        public static final ReputationEvent GOSSIP = ReputationEvent.getReputationEvent("bukkit_gossip");
        public static final ReputationEvent DECAY = ReputationEvent.getReputationEvent("bukkit_decay");
        public static final ReputationEvent GOLEM_KILLED = ReputationEvent.getReputationEvent("golem_killed");
        public static final ReputationEvent UNSPECIFIED = ReputationEvent.getReputationEvent("bukkit_unspecified");

        private static ReputationEvent getReputationEvent(String key) {
            return Bukkit.getUnsafe().createReputationEvent(key);
        }
    }

    public static interface ReputationType {
        public static final ReputationType MAJOR_NEGATIVE = ReputationType.getReputationType("major_negative");
        public static final ReputationType MINOR_NEGATIVE = ReputationType.getReputationType("minor_negative");
        public static final ReputationType MINOR_POSITIVE = ReputationType.getReputationType("minor_positive");
        public static final ReputationType MAJOR_POSITIVE = ReputationType.getReputationType("major_positive");
        public static final ReputationType TRADING = ReputationType.getReputationType("trading");

        public int getMaxValue();

        public int getWeight();

        private static ReputationType getReputationType(String key) {
            return Bukkit.getUnsafe().createReputationType(key);
        }
    }

    public static interface Profession
    extends OldEnum<Profession>,
    Keyed,
    RegistryAware {
        public static final Profession NONE = Profession.getProfession("none");
        public static final Profession ARMORER = Profession.getProfession("armorer");
        public static final Profession BUTCHER = Profession.getProfession("butcher");
        public static final Profession CARTOGRAPHER = Profession.getProfession("cartographer");
        public static final Profession CLERIC = Profession.getProfession("cleric");
        public static final Profession FARMER = Profession.getProfession("farmer");
        public static final Profession FISHERMAN = Profession.getProfession("fisherman");
        public static final Profession FLETCHER = Profession.getProfession("fletcher");
        public static final Profession LEATHERWORKER = Profession.getProfession("leatherworker");
        public static final Profession LIBRARIAN = Profession.getProfession("librarian");
        public static final Profession MASON = Profession.getProfession("mason");
        public static final Profession NITWIT = Profession.getProfession("nitwit");
        public static final Profession SHEPHERD = Profession.getProfession("shepherd");
        public static final Profession TOOLSMITH = Profession.getProfession("toolsmith");
        public static final Profession WEAPONSMITH = Profession.getProfession("weaponsmith");

        @NotNull
        private static Profession getProfession(@NotNull String key) {
            return Registry.VILLAGER_PROFESSION.getOrThrow(NamespacedKey.minecraft(key));
        }

        @Override
        @Deprecated(since="1.21.4")
        @NotNull
        public NamespacedKey getKey();

        @Deprecated(since="1.21")
        @NotNull
        public static Profession valueOf(@NotNull String name) {
            Profession profession = Registry.VILLAGER_PROFESSION.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
            Preconditions.checkArgument(profession != null, "No villager profession found with the name %s", (Object)name);
            return profession;
        }

        @Deprecated(since="1.21")
        @NotNull
        public static Profession[] values() {
            return Lists.newArrayList(Registry.VILLAGER_PROFESSION).toArray(new Profession[0]);
        }
    }

    public static interface Type
    extends OldEnum<Type>,
    Keyed,
    RegistryAware {
        public static final Type DESERT = Type.getType("desert");
        public static final Type JUNGLE = Type.getType("jungle");
        public static final Type PLAINS = Type.getType("plains");
        public static final Type SAVANNA = Type.getType("savanna");
        public static final Type SNOW = Type.getType("snow");
        public static final Type SWAMP = Type.getType("swamp");
        public static final Type TAIGA = Type.getType("taiga");

        @NotNull
        private static Type getType(@NotNull String key) {
            return Registry.VILLAGER_TYPE.getOrThrow(NamespacedKey.minecraft(key));
        }

        @Override
        @Deprecated(since="1.21.4")
        @NotNull
        public NamespacedKey getKey();

        @Deprecated(since="1.21")
        @NotNull
        public static Type valueOf(@NotNull String name) {
            Type type = Registry.VILLAGER_TYPE.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
            Preconditions.checkArgument(type != null, "No villager type found with the name %s", (Object)name);
            return type;
        }

        @Deprecated(since="1.21")
        @NotNull
        public static Type[] values() {
            return Lists.newArrayList(Registry.VILLAGER_TYPE).toArray(new Type[0]);
        }
    }
}

