/*
 * Decompiled with CFR 0.152.
 */
package net.xbzstudio.citymod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoadLightBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public RoadLightBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.METAL).sound(SoundType.LANTERN).strength(1.0f, 10.0f).lightLevel(s -> 15).noOcclusion().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)RoadLightBlock.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)4.0, (double)9.5), (VoxelShape)RoadLightBlock.box((double)-9.80391, (double)2.35773, (double)6.5, (double)10.19609, (double)5.13773, (double)9.5));
            case Direction.NORTH -> Shapes.or((VoxelShape)RoadLightBlock.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)4.0, (double)9.5), (VoxelShape)RoadLightBlock.box((double)5.80391, (double)2.35773, (double)6.5, (double)25.80391, (double)5.13773, (double)9.5));
            case Direction.EAST -> Shapes.or((VoxelShape)RoadLightBlock.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)4.0, (double)9.5), (VoxelShape)RoadLightBlock.box((double)6.5, (double)2.35773, (double)5.80391, (double)9.5, (double)5.13773, (double)25.80391));
            case Direction.WEST -> Shapes.or((VoxelShape)RoadLightBlock.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)4.0, (double)9.5), (VoxelShape)RoadLightBlock.box((double)6.5, (double)2.35773, (double)-9.80391, (double)9.5, (double)5.13773, (double)10.19609));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

