/*
 * Decompiled with CFR 0.152.
 */
package net.xbzstudio.citymod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StreetLightBBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public StreetLightBBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.METAL).sound(SoundType.LANTERN).strength(1.0f, 10.0f).lightLevel(s -> 15).noOcclusion().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)StreetLightBBlock.box((double)-6.58851, (double)6.00564, (double)6.5, (double)14.41149, (double)7.80564, (double)9.5), (VoxelShape[])new VoxelShape[]{StreetLightBBlock.box((double)11.71444, (double)1.33873, (double)6.5, (double)25.71444, (double)3.13873, (double)9.5), StreetLightBBlock.box((double)-15.58851, (double)5.85564, (double)5.5, (double)-6.58851, (double)8.78564, (double)10.5)});
            case Direction.NORTH -> Shapes.or((VoxelShape)StreetLightBBlock.box((double)1.58851, (double)6.00564, (double)6.5, (double)22.58851, (double)7.80564, (double)9.5), (VoxelShape[])new VoxelShape[]{StreetLightBBlock.box((double)-9.71444, (double)1.33873, (double)6.5, (double)4.28556, (double)3.13873, (double)9.5), StreetLightBBlock.box((double)22.58851, (double)5.85564, (double)5.5, (double)31.58851, (double)8.78564, (double)10.5)});
            case Direction.EAST -> Shapes.or((VoxelShape)StreetLightBBlock.box((double)6.5, (double)6.00564, (double)1.58851, (double)9.5, (double)7.80564, (double)22.58851), (VoxelShape[])new VoxelShape[]{StreetLightBBlock.box((double)6.5, (double)1.33873, (double)-9.71444, (double)9.5, (double)3.13873, (double)4.28556), StreetLightBBlock.box((double)5.5, (double)5.85564, (double)22.58851, (double)10.5, (double)8.78564, (double)31.58851)});
            case Direction.WEST -> Shapes.or((VoxelShape)StreetLightBBlock.box((double)6.5, (double)6.00564, (double)-6.58851, (double)9.5, (double)7.80564, (double)14.41149), (VoxelShape[])new VoxelShape[]{StreetLightBBlock.box((double)6.5, (double)1.33873, (double)11.71444, (double)9.5, (double)3.13873, (double)25.71444), StreetLightBBlock.box((double)5.5, (double)5.85564, (double)-15.58851, (double)10.5, (double)8.78564, (double)-6.58851)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }
}

