/*
 * Decompiled with CFR 0.152.
 */
package net.xbzstudio.citymod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoadSignBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public RoadSignBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)RoadSignBlock.box((double)7.25, (double)0.0, (double)7.25, (double)8.75, (double)29.0, (double)8.75), (VoxelShape)RoadSignBlock.box((double)-1.0, (double)24.0, (double)8.75, (double)17.0, (double)32.0, (double)9.025));
            case Direction.NORTH -> Shapes.or((VoxelShape)RoadSignBlock.box((double)7.25, (double)0.0, (double)7.25, (double)8.75, (double)29.0, (double)8.75), (VoxelShape)RoadSignBlock.box((double)-1.0, (double)24.0, (double)6.975, (double)17.0, (double)32.0, (double)7.25));
            case Direction.EAST -> Shapes.or((VoxelShape)RoadSignBlock.box((double)7.25, (double)0.0, (double)7.25, (double)8.75, (double)29.0, (double)8.75), (VoxelShape)RoadSignBlock.box((double)8.75, (double)24.0, (double)-1.0, (double)9.025, (double)32.0, (double)17.0));
            case Direction.WEST -> Shapes.or((VoxelShape)RoadSignBlock.box((double)7.25, (double)0.0, (double)7.25, (double)8.75, (double)29.0, (double)8.75), (VoxelShape)RoadSignBlock.box((double)6.975, (double)24.0, (double)-1.0, (double)7.25, (double)32.0, (double)17.0));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

